package com.voxeet.sdk.events.v2;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.android.media.MediaStream;
import com.voxeet.sdk.events.SuccessEvent;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.models.Participant;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromSDK;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * Event fired when a Stream has been removed for a given Participant in a specified Conference
 */
@Annotate
@FromSDK
public class StreamRemovedEvent extends SuccessEvent {

    /**
     * The Participant holding this event
     */
    @NonNull
    public Participant participant;

    /**
     * The underlying Conference instance
     */
    @NoDocumentation
    @NonNull
    public Conference conference;

    /**
     * The MediaStream which fired the event
     */
    @Nullable
    public MediaStream mediaStream;

    @NoDocumentation
    public StreamRemovedEvent(@NonNull Conference conference,
                              @NonNull Participant participant,
                              @Nullable MediaStream mediaStream) {
        this.participant = participant;
        this.conference = conference;
        this.mediaStream = mediaStream;
    }
}
