/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.utils;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.sdk.models.Participant;
import com.voxeet.sdk.models.v1.ConferenceParticipantStatus;
import com.voxeet.sdk.models.v1.ConferenceUser;
import java.util.ArrayList;
import java.util.List;

public class ConferenceUtils {
    public static final int MUTE_FACTOR = 10000;
    public static final int UNMUTE_FACTOR = 1;

    private ConferenceUtils() {
    }

    @Nullable
    public static ConferenceUser findConferenceUserById(@Nullable String userId, @Nullable List<ConferenceUser> users) {
        if (null != users) {
            for (ConferenceUser user : users) {
                if (null == userId || !userId.equalsIgnoreCase(user.getUserId())) continue;
                return user;
            }
        }
        return null;
    }

    @Nullable
    public static Participant findUserById(@Nullable String userId, @Nullable List<Participant> participants) {
        if (null != participants) {
            for (Participant participant : participants) {
                if (null == userId || !userId.equalsIgnoreCase(participant.getId())) continue;
                return participant;
            }
        }
        return null;
    }

    @NonNull
    public static List<Participant> findParticipantsMatching(@Nullable String currentUserOrEmpty, @Nullable List<Participant> merged_list) {
        ArrayList<Participant> list = new ArrayList<Participant>();
        if (null != currentUserOrEmpty && null != merged_list) {
            for (Participant participant : merged_list) {
                if (null == participant || !currentUserOrEmpty.equalsIgnoreCase(participant.getId())) continue;
                list.add(participant);
            }
        }
        return list;
    }

    public static List<Participant> getUserInState(List<Participant> conferenceParticipants, ConferenceParticipantStatus status) {
        ArrayList<Participant> participants = new ArrayList<Participant>();
        for (Participant participant : conferenceParticipants) {
            if (null == participant || !status.equals((Object)participant.getStatus())) continue;
            participants.add(participant);
        }
        return participants;
    }

    public static List<ConferenceUser> getConferenceUserInState(List<ConferenceUser> conferenceUsers, ConferenceParticipantStatus status) {
        ArrayList<ConferenceUser> users = new ArrayList<ConferenceUser>();
        for (ConferenceUser user : conferenceUsers) {
            if (null == user || !status.equals((Object)user.getConferenceStatus())) continue;
            users.add(user);
        }
        return users;
    }
}

