/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services.telemetry.rest;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.voxeet.sdk.utils.Opt;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TelemetryConfiguration {
    public long ttl = 3600L;
    public WebRtc webrtc;
    public Dvc dvc;
    public Device device;
    private long _timestamp = 0L;

    public TelemetryConfiguration() {
        this._timestamp = System.currentTimeMillis();
    }

    public TelemetryConfiguration(long ttl) {
        this.ttl = ttl;
        this._timestamp = System.currentTimeMillis();
    }

    public boolean needRefresh() {
        long diff = System.currentTimeMillis() - this._timestamp;
        return diff > this.ttl * 1000L;
    }

    public boolean enabled() {
        if (this.samplingFreqSec() == 0 || this.batch() == 0) {
            return false;
        }
        return (Boolean)Opt.of((Object)this.webrtc).then(w -> w.enabled).or((Object)false);
    }

    public int samplingFreqSec() {
        return (Integer)Opt.of((Object)this.webrtc).then(w -> w.samplingFreqSec).or((Object)10);
    }

    public int batch() {
        return (Integer)Opt.of((Object)this.webrtc).then(w -> w.batch).or((Object)3);
    }

    public String toString() {
        return "TelemetryConfiguration{ttl=" + this.ttl + ", webrtc=" + this.webrtc + ", dvc=" + this.dvc + ", device=" + this.device + ", _timestamp=" + this._timestamp + '}';
    }

    public class Device {
        public boolean enabled = true;

        public String toString() {
            return "Device{enabled=" + this.enabled + '}';
        }
    }

    public class Dvc {
        public boolean enabled = true;

        public String toString() {
            return "Dvc{enabled=" + this.enabled + '}';
        }
    }

    public class WebRtc {
        public boolean enabled = true;
        public int samplingFreqSec = 10;
        public int batch = 3;

        public String toString() {
            return "WebRtc{enabled=" + this.enabled + ", samplingFreqSec=" + this.samplingFreqSec + ", batch=" + this.batch + '}';
        }
    }
}

