/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services.telemetry.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.voxeet.VoxeetSDK;
import com.voxeet.promise.Promise;
import com.voxeet.sdk.models.v2.ServerErrorOrigin;
import com.voxeet.sdk.network.endpoints.IRestApiTelemetry;
import com.voxeet.sdk.services.AbstractPromiseable;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.services.telemetry.TelemetryAnswer;
import com.voxeet.sdk.telemetry.WebRTCStats;
import com.voxeet.sdk.utils.HttpHelper;
import com.voxeet.sdk.utils.Opt;
import java.util.List;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;

public class WebRTCStatsBatchPromise
extends AbstractPromiseable<TelemetryAnswer<Boolean>, IRestApiTelemetry> {
    private final List<WebRTCStats> webRtcStats;

    public WebRTCStatsBatchPromise(@NonNull ConferenceService parent, @NonNull MediaDeviceService mediaDeviceService, @NonNull IRestApiTelemetry provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus, @NonNull List<WebRTCStats> webRtcStats) {
        super(parent, mediaDeviceService, provider, information, eventBus);
        this.webRtcStats = webRtcStats;
    }

    @NonNull
    private String conferenceId() {
        if (this.webRtcStats.size() > 0) {
            return this.webRtcStats.get((int)0).conferenceId;
        }
        return "";
    }

    @Override
    @NonNull
    public Promise<TelemetryAnswer<Boolean>> createPromise() {
        return new Promise(solver -> {
            JsonObject main = new JsonObject();
            for (WebRTCStats webRtcStat : this.webRtcStats) {
                main.add("" + webRtcStat.timestamp, (JsonElement)webRtcStat.toJson());
                Log.d((String)"SENDING", (String)("createPromise: sending json " + webRtcStat.timestamp + ": " + webRtcStat.toJson().toString()));
            }
            MediaType JSON = MediaType.parse((String)"application/json");
            RequestBody body = RequestBody.create((MediaType)JSON, (String)main.toString());
            Call<ResponseBody> user = ((IRestApiTelemetry)this.getApiRestCall()).upload("webrtc", this.conferenceId(), VoxeetSDK.session().getParticipantId(), body);
            long original = System.currentTimeMillis();
            HttpHelper.enqueue(user, (response, object, exception) -> {
                if (null != exception) {
                    solver.reject(HttpHelper.manageThrowableOrServerError(exception, ServerErrorOrigin.TELEMETRY));
                } else {
                    int code = (Integer)Opt.of((Object)response).then(Response::code).or((Object)0);
                    solver.resolve(new TelemetryAnswer<Boolean>(original, (Headers)Opt.of((Object)response).then(Response::headers).orNull(), code >= 200 && code < 300));
                }
            });
        });
    }
}

