/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services.telemetry.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.promise.Promise;
import com.voxeet.sdk.network.endpoints.IRestApiTelemetry;
import com.voxeet.sdk.services.AbstractPromiseable;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.services.telemetry.rest.TelemetryConfiguration;
import com.voxeet.sdk.utils.HttpHelper;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;

public class TelemetryConfigurationPromise
extends AbstractPromiseable<TelemetryConfiguration, IRestApiTelemetry> {
    public TelemetryConfigurationPromise(@NonNull ConferenceService parent, @NonNull MediaDeviceService mediaDeviceService, @NonNull IRestApiTelemetry provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaDeviceService, provider, information, eventBus);
    }

    @Override
    @NonNull
    public Promise<TelemetryConfiguration> createPromise() {
        return new Promise(solver -> {
            Call<TelemetryConfiguration> configuration = ((IRestApiTelemetry)this.getApiRestCall()).configuration();
            HttpHelper.enqueue(configuration, (response, object, exception) -> {
                if (null != exception) {
                    Log.e((String)"TelemetryConfigurationPromise", (String)"creating default configuration due to issue", (Throwable)exception);
                    object = new TelemetryConfiguration(30L);
                }
                solver.resolve(object);
            });
        });
    }
}

