/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services.conference.promises;

import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.android.media.MediaEngineException;
import com.voxeet.promise.Promise;
import com.voxeet.sdk.events.promises.NotInConferenceException;
import com.voxeet.sdk.events.sdk.StartScreenShareAnswerEvent;
import com.voxeet.sdk.json.StartScreenSharingResponse;
import com.voxeet.sdk.media.MediaSDK;
import com.voxeet.sdk.models.v2.ServerErrorOrigin;
import com.voxeet.sdk.network.endpoints.IRestApiScreenShare;
import com.voxeet.sdk.services.AbstractPromiseable;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.utils.HttpHelper;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;

public class StartScreensharePromise
extends AbstractPromiseable<Boolean, IRestApiScreenShare> {
    private static final String TAG = StartScreensharePromise.class.getSimpleName();
    private final Intent intent;
    private final int width;
    private final int height;

    public StartScreensharePromise(@NonNull ConferenceService parent, @NonNull MediaDeviceService mediaDeviceService, @NonNull IRestApiScreenShare provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus, @NonNull Intent intent, int width, int height) {
        super(parent, mediaDeviceService, provider, information, eventBus);
        this.intent = intent;
        this.width = width;
        this.height = height;
    }

    @Override
    @NonNull
    public Promise<Boolean> createPromise() {
        return new Promise(solver -> {
            ConferenceInformation information = this.getInformation();
            MediaSDK media = this.getMedia();
            if (null == media) {
                Promise.reject((Throwable)new MediaEngineException("Invalid media session"));
                return;
            }
            if (null == information || !this.getParent().isInConference()) {
                media.stopVideo();
                media.stopScreenCapturer();
                Promise.reject((Throwable)new NotInConferenceException());
                return;
            }
            String conferenceId = information.getConference().getId();
            if (information.isScreenShareOn()) {
                solver.resolve((Object)true);
                return;
            }
            information.setScreenShareOn(true);
            this.getMedia().startScreenCapturer(this.intent, this.width, this.height);
            Call<StartScreenSharingResponse> startScreenShare = ((IRestApiScreenShare)this.getApiRestCall()).startScreenShare(conferenceId);
            HttpHelper.promise(startScreenShare, ServerErrorOrigin.START_SCREENSHARE).then(answer -> {
                StartScreenSharingResponse object = (StartScreenSharingResponse)answer.object;
                solver.resolve(this.createVideoAnswer(object.participantId, object.description, object.candidates));
            }).error(error -> {
                media.stopScreenCapturer();
                information.setScreenShareOn(false);
                this.getEventBus().post((Object)new StartScreenShareAnswerEvent(false));
                solver.reject(error);
            });
        });
    }
}

