/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.promise.Promise;
import com.voxeet.sdk.events.restapi.ReplayConferenceResult;
import com.voxeet.sdk.events.sdk.ConferenceStatusUpdatedEvent;
import com.voxeet.sdk.json.SdkConferenceReplayBody;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.models.v2.ServerErrorOrigin;
import com.voxeet.sdk.network.endpoints.IRestApiConferenceAccess;
import com.voxeet.sdk.services.AbstractPromiseable;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.services.conference.information.ConferenceParticipantType;
import com.voxeet.sdk.services.conference.information.ConferenceStatus;
import com.voxeet.sdk.services.conference.information.LocalConferenceType;
import com.voxeet.sdk.utils.HttpHelper;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;

public class ReplayPromise
extends AbstractPromiseable<Conference, IRestApiConferenceAccess> {
    private static final String TAG = ReplayPromise.class.getSimpleName();
    private final String conferenceId;
    private final long offset;

    public ReplayPromise(@NonNull ConferenceService parent, @NonNull MediaDeviceService mediaDeviceService, @NonNull IRestApiConferenceAccess provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus, @NonNull String conferenceId, long offset) {
        super(parent, mediaDeviceService, provider, information, eventBus);
        this.conferenceId = conferenceId;
        this.offset = offset;
    }

    @Override
    @NonNull
    public Promise<Conference> createPromise() {
        return new Promise(solver -> {
            ConferenceInformation information = this.getConferenceInformation(this.conferenceId);
            information.setConferenceParticipantType(ConferenceParticipantType.LISTENER);
            Call<ReplayConferenceResult> user = ((IRestApiConferenceAccess)this.getApiRestCall()).replay(this.conferenceId, new SdkConferenceReplayBody(this.offset));
            HttpHelper.enqueue(user, (response, object, exception) -> {
                if (null != exception || null == object) {
                    if (null == exception) {
                        exception = new IllegalStateException("invalid object received in replay promise");
                    }
                    ConferenceStatusUpdatedEvent state = new ConferenceStatusUpdatedEvent(this.conferenceId, ConferenceStatus.ERROR);
                    this.getEventBus().post((Object)state);
                    this.log("Error while replay conference : creation process part");
                    solver.reject(HttpHelper.manageThrowableOrServerError(exception, ServerErrorOrigin.CREATE));
                } else {
                    Log.d((String)TAG, (String)("Success server answer for replaying mConference with id: " + this.conferenceId + "at offset: " + this.offset + " given := " + object.conferenceId + " " + object.conferenceAlias + " " + information));
                    this.moveConference(object.conferenceId, information);
                    information.getConference().setConferenceId(object.conferenceId).setConferenceAlias(object.conferenceAlias);
                    information.setConferenceType(LocalConferenceType.REPLAY);
                    solver.resolve(this.joinConference(information));
                }
            });
        });
    }
}

