/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.VoxeetSDK;
import com.voxeet.promise.Promise;
import com.voxeet.sdk.json.SdkConferenceInvitation;
import com.voxeet.sdk.models.Participant;
import com.voxeet.sdk.models.v1.ConferenceParticipantStatus;
import com.voxeet.sdk.models.v2.ServerErrorOrigin;
import com.voxeet.sdk.network.endpoints.IRestApiConferenceAccess;
import com.voxeet.sdk.services.AbstractPromiseable;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.SessionService;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.utils.HttpHelper;
import com.voxeet.sdk.utils.Opt;
import java.util.ArrayList;
import java.util.List;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;

public class InvitePromise
extends AbstractPromiseable<List<Participant>, IRestApiConferenceAccess> {
    private final String TAG = InvitePromise.class.getSimpleName();
    private final List<String> ids;
    private final String conferenceId;

    public InvitePromise(@NonNull ConferenceService parent, @NonNull MediaDeviceService mediaDeviceService, @NonNull IRestApiConferenceAccess provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus, @NonNull String conferenceId, @NonNull List<String> ids) {
        super(parent, mediaDeviceService, provider, information, eventBus);
        this.ids = ids;
        this.conferenceId = conferenceId;
    }

    @Override
    @NonNull
    public Promise<List<Participant>> createPromise() {
        return new Promise(solver -> {
            this.removeTimeoutCallbacks();
            this.sendTimeoutCallbacks();
            boolean sdk = this.isSDK();
            ArrayList<String> voxeetIds = sdk ? null : new ArrayList<String>();
            ArrayList<String> externalIds = new ArrayList<String>(this.ids);
            if (!sdk) {
                voxeetIds.addAll(this.ids);
            }
            if (null == this.conferenceId) {
                Promise.reject((Throwable)new IllegalStateException("You're not in a conference"));
                return;
            }
            Call<ResponseBody> user = ((IRestApiConferenceAccess)this.getApiRestCall()).invite(this.conferenceId, new SdkConferenceInvitation(voxeetIds, externalIds));
            HttpHelper.enqueue(user, (response, object, exception) -> {
                if (null != exception) {
                    solver.reject(HttpHelper.manageThrowableOrServerError(exception, ServerErrorOrigin.INVITE));
                } else {
                    ArrayList<Participant> list = new ArrayList<Participant>();
                    String localId = (String)Opt.of((Object)VoxeetSDK.session()).then(SessionService::getParticipantId).or((Object)"");
                    if ((Integer)Opt.of((Object)response).then(Response::code).or((Object)0) == 200) {
                        for (String userId : externalIds) {
                            if (userId.equals(localId)) continue;
                            list.add(this.updateConferenceParticipants(userId, ConferenceParticipantStatus.IN_PROGRESS));
                        }
                    }
                    solver.resolve(list);
                }
            });
        });
    }
}

