/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services.abstracts;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.VoxeetSDK;
import com.voxeet.promise.Promise;
import com.voxeet.promise.solve.ErrorPromise;
import com.voxeet.promise.solve.PromiseExec;
import com.voxeet.promise.solve.PromiseSolver;
import com.voxeet.promise.solve.Solver;
import com.voxeet.sdk.services.AbstractVoxeetService;
import com.voxeet.sdk.services.SdkEnvironmentHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public abstract class AbstractPresentationService<KLASS, CONSUME_EVENT_TYPE>
extends AbstractVoxeetService<KLASS> {
    protected List<CONSUME_EVENT_TYPE> presentations = new ArrayList<CONSUME_EVENT_TYPE>();

    protected AbstractPresentationService(@NonNull SdkEnvironmentHolder instance, @Nullable Class<KLASS> service_klass) {
        super(instance, service_klass);
    }

    protected String getConferenceId() {
        return VoxeetSDK.conference().getConferenceId();
    }

    protected Promise<Response<ResponseBody>> internalCall(final Call<ResponseBody> observable_caller) {
        return new Promise((PromiseSolver)new PromiseSolver<Response<ResponseBody>>(){

            public void onCall(final @NonNull Solver<Response<ResponseBody>> solver) {
                String conferenceId = VoxeetSDK.conference().getConferenceId();
                if (null == conferenceId) {
                    solver.reject((Throwable)new IllegalStateException("Not in conference"));
                    return;
                }
                observable_caller.enqueue((Callback)new Callback<ResponseBody>(){

                    public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                        if (response.code() >= 200 && response.code() < 300) {
                            solver.resolve(response);
                        } else {
                            try {
                                throw new IllegalStateException("Exception while managing presentation, invalid state ?");
                            }
                            catch (IllegalStateException exception) {
                                solver.reject((Throwable)exception);
                            }
                        }
                    }

                    public void onFailure(Call<ResponseBody> call, Throwable t) {
                        solver.reject(t);
                    }
                });
            }
        });
    }

    protected <PROMISE_RETURN_TYPE, EVENT_TYPE> void consumeInternalCall(final Solver<EVENT_TYPE> solver, final String key, final HashMap<String, Solver<EVENT_TYPE>> list, Promise<PROMISE_RETURN_TYPE> promise) {
        promise.then(new PromiseExec<PROMISE_RETURN_TYPE, EVENT_TYPE>(){

            public void onCall(@Nullable PROMISE_RETURN_TYPE responseBodyResponse, @NonNull Solver<EVENT_TYPE> internal_solver) {
                list.put(key, solver);
            }
        }).error(new ErrorPromise(){

            public void onError(@NonNull Throwable throwable) {
                solver.reject(throwable);
            }
        });
    }

    protected <PROMISE_RETURN_TYPE, EVENT_TYPE> void consumeInternalCall(final Solver<CONSUME_EVENT_TYPE> solver, final List<Solver<CONSUME_EVENT_TYPE>> list, Promise<PROMISE_RETURN_TYPE> promise) {
        promise.then(new PromiseExec<PROMISE_RETURN_TYPE, EVENT_TYPE>(){

            public void onCall(@Nullable PROMISE_RETURN_TYPE responseBodyResponse, @NonNull Solver<EVENT_TYPE> internal_solver) {
                list.add(solver);
            }
        }).error(new ErrorPromise(){

            public void onError(@NonNull Throwable throwable) {
                solver.reject(throwable);
            }
        });
    }

    protected <PRESENTATION> void tryUnlock(String fileId, PRESENTATION object, HashMap<String, Solver<PRESENTATION>> maps) {
        Solver<PRESENTATION> solver = maps.get(fileId);
        if (null != solver) {
            solver.resolve(object);
            if (maps.containsKey(fileId)) {
                maps.remove(solver);
            }
        }
    }

    protected <PRESENTATION> void tryUnlock(PRESENTATION object, List<Solver<PRESENTATION>> list) {
        for (Solver<PRESENTATION> solver : list) {
            if (null == solver) continue;
            solver.resolve(object);
        }
        list.clear();
    }
}

