/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services;

import android.support.annotation.NonNull;
import com.voxeet.promise.Promise;
import com.voxeet.promise.solve.Solver;
import com.voxeet.sdk.json.VideoPresentationPaused;
import com.voxeet.sdk.json.VideoPresentationPlay;
import com.voxeet.sdk.json.VideoPresentationSeek;
import com.voxeet.sdk.json.VideoPresentationStarted;
import com.voxeet.sdk.json.VideoPresentationStopped;
import com.voxeet.sdk.network.endpoints.IRestApiVideoPresentation;
import com.voxeet.sdk.services.SdkEnvironmentHolder;
import com.voxeet.sdk.services.abstracts.AbstractPresentationService;
import com.voxeet.sdk.services.presentation.PresentationState;
import com.voxeet.sdk.services.presentation.video.VideoPresentation;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

@Annotate
public class VideoPresentationService
extends AbstractPresentationService<IRestApiVideoPresentation, VideoPresentation> {
    private List<Solver<VideoPresentation>> mCacheStartedSolvers;
    private List<Solver<VideoPresentation>> mCacheStoppedSolvers;
    private List<Solver<VideoPresentation>> mCachePausedSolvers = new ArrayList<Solver<VideoPresentation>>();
    private List<Solver<VideoPresentation>> mCachePlaySolvers;
    private List<Solver<VideoPresentation>> mCacheSeekSolvers;

    @NoDocumentation
    public VideoPresentationService(@NonNull SdkEnvironmentHolder instance) {
        super(instance, IRestApiVideoPresentation.class);
        this.mCacheStartedSolvers = new ArrayList<Solver<VideoPresentation>>();
        this.mCacheStoppedSolvers = new ArrayList<Solver<VideoPresentation>>();
        this.mCachePausedSolvers = new ArrayList<Solver<VideoPresentation>>();
        this.mCachePlaySolvers = new ArrayList<Solver<VideoPresentation>>();
        this.mCacheSeekSolvers = new ArrayList<Solver<VideoPresentation>>();
        this.registerEventBus();
    }

    @NoDocumentation
    void onInternalServiceEvent(VideoPresentationStarted event) {
        VideoPresentation information = this.getPresentationInformation(event.key);
        information.url = event.url;
        this.presentations.add(information);
        information.state = PresentationState.STARTED;
        information.lastSeekTimestamp = event.timestamp;
        this.getEventBus().post((Object)event);
        this.tryUnlock(information, this.mCacheStartedSolvers);
    }

    @NoDocumentation
    void onInternalServiceEvent(VideoPresentationStopped event) {
        VideoPresentation information = this.getPresentationInformation(event.key);
        information.state = PresentationState.STOP;
        this.presentations.remove(information);
        this.getEventBus().post((Object)event);
        this.tryUnlock(information, this.mCacheStoppedSolvers);
    }

    @NoDocumentation
    void onInternalServiceEvent(VideoPresentationPaused event) {
        VideoPresentation information = this.getPresentationInformation(event.key);
        information.state = PresentationState.PAUSED;
        information.lastSeekTimestamp = event.timestamp;
        this.getEventBus().post((Object)event);
        this.tryUnlock(information, this.mCachePausedSolvers);
    }

    @NoDocumentation
    void onInternalServiceEvent(VideoPresentationPlay event) {
        VideoPresentation information = this.getPresentationInformation(event.key);
        information.state = PresentationState.PLAY;
        information.lastSeekTimestamp = event.timestamp;
        this.getEventBus().post((Object)event);
        this.tryUnlock(information, this.mCachePlaySolvers);
    }

    @NoDocumentation
    void onInternalServiceEvent(VideoPresentationSeek event) {
        VideoPresentation information = this.getPresentationInformation(event.key);
        information.state = PresentationState.SEEK;
        information.lastSeekTimestamp = event.timestamp;
        this.getEventBus().post((Object)event);
        this.tryUnlock(information, this.mCacheSeekSolvers);
    }

    @NonNull
    public Promise<VideoPresentation> start(@NonNull String url) {
        return new Promise(solver -> {
            IRestApiVideoPresentation.VideoPresentationUrl holder = new IRestApiVideoPresentation.VideoPresentationUrl(url);
            this.consumeInternalCall(solver, this.mCacheStartedSolvers, this.internalCall(((IRestApiVideoPresentation)this.getService()).startVideoPresentation(this.getConferenceId(), holder)));
        });
    }

    @NonNull
    public Promise<VideoPresentation> stop() {
        return new Promise(solver -> this.consumeInternalCall(solver, this.mCacheStoppedSolvers, this.internalCall(((IRestApiVideoPresentation)this.getService()).stopVideoPresentation(this.getConferenceId()))));
    }

    @NonNull
    public Promise<VideoPresentation> play() {
        return new Promise(solver -> this.consumeInternalCall(solver, this.mCachePlaySolvers, this.internalCall(((IRestApiVideoPresentation)this.getService()).playVideoPresentation(this.getConferenceId()))));
    }

    @NonNull
    public Promise<VideoPresentation> pause(long timestamp) {
        return new Promise(solver -> {
            IRestApiVideoPresentation.VideoPresentationSeek body_sent = new IRestApiVideoPresentation.VideoPresentationSeek(timestamp);
            this.consumeInternalCall(solver, this.mCachePausedSolvers, this.internalCall(((IRestApiVideoPresentation)this.getService()).pauseVideoPresentation(this.getConferenceId(), body_sent)));
        });
    }

    @NonNull
    public Promise<VideoPresentation> seek(long timestamp) {
        return new Promise(solver -> {
            IRestApiVideoPresentation.VideoPresentationSeek body_sent = new IRestApiVideoPresentation.VideoPresentationSeek(timestamp);
            this.consumeInternalCall(solver, this.mCacheSeekSolvers, this.internalCall(((IRestApiVideoPresentation)this.getService()).seekVideoPresentation(this.getConferenceId(), body_sent)));
        });
    }

    @Nullable
    public VideoPresentation getCurrentPresentation() {
        for (VideoPresentation information : this.presentations) {
            if (PresentationState.STOP.equals((Object)information.state)) continue;
            return information.clone();
        }
        return null;
    }

    @NonNull
    private VideoPresentation getPresentationInformation(@NonNull String key) {
        for (VideoPresentation information : this.presentations) {
            if (!key.equals(information.key)) continue;
            return information;
        }
        return new VideoPresentation(key, "");
    }
}

