/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services;

import android.support.annotation.NonNull;
import com.voxeet.VoxeetSDK;
import com.voxeet.promise.Promise;
import com.voxeet.sdk.json.RecordingStatusUpdatedEvent;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.models.Participant;
import com.voxeet.sdk.models.v1.RecordingStatus;
import com.voxeet.sdk.network.endpoints.IRestApiRecording;
import com.voxeet.sdk.services.AbstractVoxeetService;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.SdkEnvironmentHolder;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.services.conference.promises.StartRecordingPromiseable;
import com.voxeet.sdk.services.conference.promises.StopRecordingPromiseable;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;
import java.util.Date;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

@Annotate
public class RecordingService
extends AbstractVoxeetService<IRestApiRecording> {
    private static final String TAG = RecordingService.class.getSimpleName();
    private boolean isRecording = false;
    private boolean isICERestartEnabled = false;

    @NoDocumentation
    public RecordingService(@NonNull SdkEnvironmentHolder instance) {
        super(instance, IRestApiRecording.class);
        this.registerEventBus();
    }

    public Promise<Boolean> start() {
        ConferenceService service = VoxeetSDK.conference();
        return new StartRecordingPromiseable(service, VoxeetSDK.mediaDevice(), (IRestApiRecording)this.getService(), service.getCurrentConference(), this.getEventBus()).createPromise();
    }

    public Promise<Boolean> stop() {
        ConferenceService service = VoxeetSDK.conference();
        return new StopRecordingPromiseable(service, VoxeetSDK.mediaDevice(), (IRestApiRecording)this.getService(), service.getCurrentConference(), this.getEventBus()).createPromise();
    }

    @Subscribe(threadMode=ThreadMode.MAIN, priority=999)
    public void onEvent(RecordingStatusUpdatedEvent recordingStatusUpdateEvent) {
        ConferenceService service = VoxeetSDK.conference();
        String conferenceId = recordingStatusUpdateEvent.conferenceId;
        ConferenceInformation information = service.getConferenceInformation(conferenceId);
        Conference conference = information.getConference();
        Participant participant = service.findParticipantById(recordingStatusUpdateEvent.participantId);
        if (participant != null) {
            Conference.RecordingInformation recording = new Conference.RecordingInformation();
            RecordingStatus status = RecordingStatus.valueOf(recordingStatusUpdateEvent.recordingStatus);
            if (status == RecordingStatus.RECORDING) {
                this.isRecording = true;
                recording.setStartRecordTimestamp(new Date(recordingStatusUpdateEvent.timeStamp));
                recording.setRecordingStatus(RecordingStatus.RECORDING);
                recording.setRecordingParticipant(recordingStatusUpdateEvent.participantId);
            } else {
                this.isRecording = false;
                recording.setStartRecordTimestamp(null);
                recording.setRecordingStatus(RecordingStatus.NOT_RECORDING);
                recording.setRecordingParticipant(null);
            }
            conference.setRecordingInformation(recording);
        }
    }
}

