/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.VoxeetSDK;
import com.voxeet.promise.solve.ErrorPromise;
import com.voxeet.sdk.push.utils.NoDocumentation;
import com.voxeet.sdk.services.SdkEnvironmentHolder;
import com.voxeet.sdk.services.VoxeetHttp;
import com.voxeet.sdk.services.holder.ServiceProviderHolder;
import org.greenrobot.eventbus.EventBus;

public abstract class AbstractVoxeetService<T> {
    private static final String TAG = AbstractVoxeetService.class.getSimpleName();
    private SdkEnvironmentHolder sdk_environment_holder;
    @NonNull
    private ServiceProviderHolder<T> holder = ServiceProviderHolder.DEFAULT;
    protected static final Handler handler = new Handler(Looper.getMainLooper());
    protected Context context;

    private AbstractVoxeetService() {
    }

    protected AbstractVoxeetService(@NonNull SdkEnvironmentHolder holder, @Nullable Class<T> service_klass) {
        this(holder, new ServiceProviderHolder.Builder().setClient(holder.voxeetHttp).setService(service_klass).build());
    }

    protected AbstractVoxeetService(@NonNull SdkEnvironmentHolder instance, @NonNull ServiceProviderHolder<T> holder) {
        this();
        this.sdk_environment_holder = instance;
        this.context = instance.voxeetSdk.getApplicationContext();
        this.holder = holder;
    }

    @Nullable
    protected final T getService() {
        return this.holder.getService();
    }

    @Nullable
    protected final <TYPE> TYPE getService(Class<TYPE> klass) {
        return this.holder.getService(klass);
    }

    public String handleError(@Nullable Throwable e) {
        if (null == e) {
            return "invalid error";
        }
        Log.d((String)TAG, (String)("handleError: " + e.getClass().getSimpleName()));
        return e.getMessage();
    }

    public void resetService() {
    }

    @Nullable
    protected final String getURLRoot() {
        return this.sdk_environment_holder.voxeetHttp.getBuiltServerUrl();
    }

    @Nullable
    protected final String getInternalToken() {
        return this.sdk_environment_holder.voxeetHttp.getToken();
    }

    @Nullable
    protected final String getInternalJwtToken() {
        return this.getVoxeetHttp().getJwtToken();
    }

    protected final VoxeetHttp getVoxeetHttp() {
        return this.sdk_environment_holder.voxeetHttp;
    }

    protected final SdkEnvironmentHolder getSdkEnvironmentHolder() {
        return this.sdk_environment_holder;
    }

    protected final VoxeetSDK getVoxeetSDK() {
        return this.getSdkEnvironmentHolder().voxeetSdk;
    }

    protected EventBus getEventBus() {
        return this.holder.getEventBus();
    }

    protected void registerEventBus() {
        EventBus eventBus = this.holder.getEventBus();
        try {
            if (!eventBus.isRegistered((Object)this)) {
                eventBus.register((Object)this);
            }
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"registerEventBus: logging for debug purposes :");
            e.printStackTrace();
        }
    }

    protected void unRegisterEventBus() {
        EventBus eventBus = this.holder.getEventBus();
        try {
            if (eventBus.isRegistered((Object)this)) {
                eventBus.unregister((Object)this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void postOnMainThread(@NonNull Runnable runnable) {
        handler.post(runnable);
    }

    protected boolean isInProperServiceState(AbstractVoxeetService ... services) {
        if (null == services || services.length == 0) {
            return false;
        }
        for (AbstractVoxeetService service : services) {
            if (null != service) continue;
            return false;
        }
        return true;
    }

    protected boolean throwInvalidServices() {
        throw new IllegalStateException("Invalid service state... stopping...");
    }

    @NoDocumentation
    @NonNull
    protected ErrorPromise manageError() {
        return Throwable::printStackTrace;
    }
}

