/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.media;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.PowerManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.sdk.media.audio.AudioRoute;

public class MediaPowerManager
implements SensorEventListener {
    private static final String TAG = MediaPowerManager.class.getSimpleName();
    private static final int PROXIMITY_SCREEN_OFF_WAKE_LOCK = 32;
    private SensorManager mSensorManager;
    @Nullable
    private PowerManager.WakeLock mProximityWakeLock;
    private PowerManager.WakeLock mPartialWakeLock;
    private WifiManager.WifiLock mWifiLock;
    @Nullable
    private Sensor mProximity;
    private boolean shouldRegisterForProximity = false;
    private AudioRoute mAudioRoute = AudioRoute.ROUTE_SPEAKER;

    public MediaPowerManager(@NonNull Context context, @NonNull AudioRoute defaultAudioRoute) {
        this.setAudioRoute(defaultAudioRoute);
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        WifiManager wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
        this.mSensorManager = (SensorManager)context.getSystemService("sensor");
        if (null != this.mSensorManager) {
            this.mProximity = this.mSensorManager.getDefaultSensor(8);
        }
        if (Build.VERSION.SDK_INT >= 21 || Build.VERSION.SDK_INT < 21 && !Build.BRAND.contains("samsung")) {
            this.shouldRegisterForProximity = true;
        }
        try {
            if (null != powerManager) {
                this.mProximityWakeLock = Build.VERSION.SDK_INT >= 21 ? powerManager.newWakeLock(32, TAG) : powerManager.newWakeLock(32, TAG);
                this.mPartialWakeLock = powerManager.newWakeLock(1, TAG);
            }
            if (null != wifiManager) {
                this.mWifiLock = wifiManager.createWifiLock(3, TAG);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed to create required WakeLock");
        }
    }

    public void acquire() {
        if (this.shouldRegisterForProximity && null != this.mProximity) {
            this.mSensorManager.registerListener((SensorEventListener)this, this.mProximity, 3);
        }
        if (null != this.mPartialWakeLock && !this.mPartialWakeLock.isHeld()) {
            this.acquirePartial();
        }
        if (null != this.mWifiLock && !this.mWifiLock.isHeld()) {
            this.mWifiLock.acquire();
        }
    }

    public void release() {
        if (this.shouldRegisterForProximity) {
            this.mSensorManager.unregisterListener((SensorEventListener)this);
        }
        if (null != this.mPartialWakeLock && this.mPartialWakeLock.isHeld()) {
            this.mPartialWakeLock.release();
        }
        if (null != this.mWifiLock && this.mWifiLock.isHeld()) {
            this.mWifiLock.release();
        }
        if (null != this.mProximityWakeLock && this.mProximityWakeLock.isHeld()) {
            this.mProximityWakeLock.release();
        }
    }

    public final void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public final void onSensorChanged(SensorEvent event) {
        float distance = event.values[0];
        if (Build.VERSION.SDK_INT >= 21) {
            if (AudioRoute.ROUTE_PHONE.equals((Object)this.mAudioRoute) && this.mProximityWakeLock != null && !this.mProximityWakeLock.isHeld()) {
                if (distance <= 5.0f) {
                    this.acquireProximity();
                }
            } else if (this.mProximityWakeLock != null && this.mProximityWakeLock.isHeld()) {
                this.mProximityWakeLock.release(0);
            }
        }
    }

    public void updateProximitySensor(@NonNull AudioRoute route) {
        if (null != this.mProximityWakeLock) {
            if (AudioRoute.ROUTE_PHONE.equals((Object)route)) {
                this.acquireProximity();
            } else {
                this.mProximityWakeLock.release();
            }
        }
    }

    public void setAudioRoute(@NonNull AudioRoute route) {
        this.mAudioRoute = route;
    }

    private void acquireProximity() {
        if (null != this.mProximityWakeLock) {
            this.mProximityWakeLock.acquire();
        }
    }

    private void acquirePartial() {
        if (null != this.mPartialWakeLock) {
            this.mPartialWakeLock.acquire();
        }
    }
}

