/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.factories;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.voxeet.sdk.json.Event;

public class EventsFactory {
    private static final String TAG = EventsFactory.class.getSimpleName();
    private static ObjectMapper objectMapper = new ObjectMapper();

    private EventsFactory() {
    }

    @Nullable
    public static <T> T mapping(String message, Class<T> klass) {
        try {
            return (T)objectMapper.readValue(message, klass);
        }
        catch (Throwable e) {
            Log.e((String)Event.TAG, (String)("failed to decode command := " + e.getMessage()));
            return null;
        }
    }

    @Nullable
    public static Event decode(String message) {
        try {
            Event event = (Event)objectMapper.readValue(message, Event.class);
            Log.d((String)TAG, (String)("decode: event := " + event.getType()));
            return event;
        }
        catch (Throwable e) {
            Log.e((String)Event.TAG, (String)("failed to decode command := " + e.getMessage()));
            return null;
        }
    }

    @Nullable
    public static String getJson(@NonNull Object event) {
        ObjectMapper om = new ObjectMapper();
        try {
            return objectMapper.writeValueAsString(event);
        }
        catch (JsonProcessingException e) {
            Log.e((String)TAG, (String)"failed to send command", (Throwable)e);
            return null;
        }
    }
}

