/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.voxeet.promise.Promise;
import com.voxeet.sdk.authent.token.RefreshTokenCallback;
import com.voxeet.sdk.exceptions.ExceptionManager;
import com.voxeet.sdk.exceptions.VoxeetSentry;
import com.voxeet.sdk.log.endpoints.LogEndpoints;
import com.voxeet.sdk.log.factory.LogFactory;
import com.voxeet.sdk.preferences.VoxeetPreferences;
import com.voxeet.sdk.services.AbstractVoxeetService;
import com.voxeet.sdk.services.AudioService;
import com.voxeet.sdk.services.ChatService;
import com.voxeet.sdk.services.CommandService;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.FilePresentationService;
import com.voxeet.sdk.services.LocalStatsService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.NotificationService;
import com.voxeet.sdk.services.RecordingService;
import com.voxeet.sdk.services.ScreenShareService;
import com.voxeet.sdk.services.SdkEnvironmentHolder;
import com.voxeet.sdk.services.SessionService;
import com.voxeet.sdk.services.TelemetryService;
import com.voxeet.sdk.services.VideoPresentationService;
import com.voxeet.sdk.services.VoxeetHttp;
import com.voxeet.sdk.utils.AbstractVoxeetEnvironmentHolder;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.BackendAccessHolder;
import com.voxeet.sdk.utils.NoDocumentation;
import com.voxeet.sdk.utils.VoxeetEnvironmentHolder;
import com.voxeet.sdk.utils.converter.EnumConverterFactory;
import com.voxeet.sdk.utils.converter.JacksonConverterFactory;
import java.util.HashMap;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.EventBusException;
import retrofit2.Converter;
import retrofit2.Retrofit;

@Annotate
public final class VoxeetSDK {
    private static final String TAG = VoxeetSDK.class.getSimpleName();
    private static final long DEFAULT_TIMEOUT_MS = -1L;
    private static Context CurrentApplication = null;
    private static VoxeetEnvironmentHolder VoxeetEnvironmentHolder;
    private static VoxeetSDK CurrentInstance;
    private final Retrofit _retrofit;
    private SdkEnvironmentHolder _sdk_environment_holder;
    private VoxeetHttp _voxeet_http;
    private EventBus _event_bus;
    private BackendAccessHolder _backend_access_holder;
    private HashMap<Class<? extends AbstractVoxeetService>, AbstractVoxeetService> _services;
    private VoxeetSentry voxeetSentry;

    @NoDocumentation
    protected static void setInstance(@NonNull VoxeetSDK sdk) {
        CurrentInstance = sdk;
        VoxeetPreferences.init(sdk.getApplicationContext(), sdk.getVoxeetEnvironmentHolder());
    }

    @NonNull
    public static VoxeetSDK instance() {
        return CurrentInstance;
    }

    @NoDocumentation
    public static void setApplication(@NonNull Context application) {
        CurrentApplication = application;
        VoxeetEnvironmentHolder = new VoxeetEnvironmentHolder(application);
    }

    public static synchronized void initialize(@NonNull String appId, @NonNull String password) {
        if (null == CurrentInstance) {
            VoxeetSDK sdk = new VoxeetSDK(appId, password, null, null);
            VoxeetSDK.setInstance(sdk);
        } else {
            Log.d((String)TAG, (String)"initialize: Instance already started !");
        }
    }

    public static synchronized void initialize(@NonNull String accessToken, @NonNull RefreshTokenCallback refreshToken) {
        if (null == CurrentInstance) {
            VoxeetSDK sdk = new VoxeetSDK(null, null, accessToken, refreshToken);
            VoxeetSDK.setInstance(sdk);
        } else {
            Log.d((String)TAG, (String)"initialize: Instance already started !");
        }
    }

    private VoxeetSDK(@Nullable String appId, @Nullable String password, @Nullable String tokenAccess, @Nullable RefreshTokenCallback tokenRefresh) {
        this.initExceptionIfOk(CurrentApplication);
        Retrofit retrofit = new Retrofit.Builder().addConverterFactory((Converter.Factory)JacksonConverterFactory.create(new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES))).addConverterFactory((Converter.Factory)new EnumConverterFactory()).baseUrl("https://report.voxeet.com").build();
        this._backend_access_holder = new BackendAccessHolder(appId, password, tokenAccess, tokenRefresh);
        LogEndpoints endpoint = (LogEndpoints)retrofit.create(LogEndpoints.class);
        LogFactory.instance.init(endpoint);
        this._event_bus = EventBus.getDefault();
        Promise.setHandler((Handler)new Handler(Looper.getMainLooper()));
        Log.d((String)"VoxeetSDK", (String)("VoxeetSdk: version := " + VoxeetEnvironmentHolder.getVersionName()));
        this._voxeet_http = new VoxeetHttp(this, this._backend_access_holder);
        this._retrofit = this._voxeet_http.getRetrofit();
        this._sdk_environment_holder = new SdkEnvironmentHolder(this._retrofit, this._voxeet_http.getClient(), this, this._voxeet_http, (AbstractVoxeetEnvironmentHolder)VoxeetEnvironmentHolder);
        this._services = new HashMap();
        VoxeetPreferences.init(this.getApplicationContext(), this.getVoxeetEnvironmentHolder());
        this.initServices();
    }

    @NoDocumentation
    @NonNull
    public static ChatService chat() {
        if (null == VoxeetSDK.instance()) {
            return null;
        }
        return VoxeetSDK.instance().getServiceForKlass(ChatService.class);
    }

    @NonNull
    public static ConferenceService conference() {
        if (null == VoxeetSDK.instance()) {
            return null;
        }
        return VoxeetSDK.instance().getServiceForKlass(ConferenceService.class);
    }

    @NonNull
    public static MediaDeviceService mediaDevice() {
        if (null == VoxeetSDK.instance()) {
            return null;
        }
        return VoxeetSDK.instance().getServiceForKlass(MediaDeviceService.class);
    }

    @NonNull
    public static ScreenShareService screenShare() {
        if (null == VoxeetSDK.instance()) {
            return null;
        }
        return VoxeetSDK.instance().getServiceForKlass(ScreenShareService.class);
    }

    @NonNull
    public static SessionService session() {
        if (null == VoxeetSDK.instance()) {
            return null;
        }
        return VoxeetSDK.instance().getServiceForKlass(SessionService.class);
    }

    @NonNull
    public static FilePresentationService filePresentation() {
        if (null == VoxeetSDK.instance()) {
            return null;
        }
        return VoxeetSDK.instance().getServiceForKlass(FilePresentationService.class);
    }

    @NonNull
    public static VideoPresentationService videoPresentation() {
        if (null == VoxeetSDK.instance()) {
            return null;
        }
        return VoxeetSDK.instance().getServiceForKlass(VideoPresentationService.class);
    }

    @NonNull
    public static AudioService audio() {
        if (null == VoxeetSDK.instance()) {
            return null;
        }
        return VoxeetSDK.instance().getServiceForKlass(AudioService.class);
    }

    @NonNull
    public static RecordingService recording() {
        if (null == VoxeetSDK.instance()) {
            return null;
        }
        return VoxeetSDK.instance().getServiceForKlass(RecordingService.class);
    }

    @NonNull
    public static CommandService command() {
        if (null == VoxeetSDK.instance()) {
            return null;
        }
        return VoxeetSDK.instance().getServiceForKlass(CommandService.class);
    }

    @NoDocumentation
    @NonNull
    public static LocalStatsService localStats() {
        if (null == VoxeetSDK.instance()) {
            return null;
        }
        return VoxeetSDK.instance().getServiceForKlass(LocalStatsService.class);
    }

    @NonNull
    public static NotificationService notification() {
        if (null == VoxeetSDK.instance()) {
            return null;
        }
        return VoxeetSDK.instance().getServiceForKlass(NotificationService.class);
    }

    @NoDocumentation
    @NonNull
    public static TelemetryService telemetry() {
        if (null == VoxeetSDK.instance()) {
            return null;
        }
        return VoxeetSDK.instance().getServiceForKlass(TelemetryService.class);
    }

    @NoDocumentation
    public Context getApplicationContext() {
        return CurrentApplication;
    }

    @NoDocumentation
    public AbstractVoxeetEnvironmentHolder getVoxeetEnvironmentHolder() {
        return VoxeetEnvironmentHolder;
    }

    @NonNull
    public EventBus getEventBus() {
        return this._event_bus;
    }

    public boolean register(@Nullable Object subscriber) {
        try {
            EventBus eventBus = this.getEventBus();
            if (null != subscriber && !eventBus.isRegistered(subscriber)) {
                eventBus.register(subscriber);
            }
        }
        catch (EventBusException error) {
            error.printStackTrace();
            return false;
        }
        return true;
    }

    public void unregister(@NonNull Object subscriber) {
        try {
            if (this.getEventBus().isRegistered(subscriber)) {
                this.getEventBus().unregister(subscriber);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private HashMap<Class<? extends AbstractVoxeetService>, AbstractVoxeetService> getServices() {
        return this._services;
    }

    private void initExceptionIfOk(@NonNull Context application_context) {
        Log.d((String)TAG, (String)"initExceptionIfOk: checking for exception to log internally");
        this.voxeetSentry = new VoxeetSentry(application_context);
        ExceptionManager.register(this.voxeetSentry);
        Log.d((String)TAG, (String)"initExceptionIfOk: finished to try implementing error management");
    }

    private <T extends AbstractVoxeetService> T getServiceForKlass(Class<T> klass) {
        AbstractVoxeetService service = null;
        for (Class<? extends AbstractVoxeetService> next : this._services.keySet()) {
            AbstractVoxeetService item = this._services.get(next);
            if (!klass.isInstance(item)) continue;
            service = item;
        }
        if (service == null) {
            Log.d((String)TAG, (String)(klass.getSimpleName() + " not found in the list of services"));
        }
        return (T)service;
    }

    public static void region(@NonNull String region) {
        VoxeetEnvironmentHolder.setRegion(region);
    }

    private void initServices() {
        this.getServices().put(AudioService.class, new AudioService(this._sdk_environment_holder));
        this.getServices().put(ConferenceService.class, new ConferenceService(this._sdk_environment_holder, -1L));
        this.getServices().put(SessionService.class, new SessionService(this._sdk_environment_holder));
        this.getServices().put(FilePresentationService.class, new FilePresentationService(this._sdk_environment_holder));
        this.getServices().put(VideoPresentationService.class, new VideoPresentationService(this._sdk_environment_holder));
        this.getServices().put(ScreenShareService.class, new ScreenShareService(this._sdk_environment_holder));
        this.getServices().put(MediaDeviceService.class, new MediaDeviceService(this._sdk_environment_holder));
        this.getServices().put(LocalStatsService.class, new LocalStatsService(this._sdk_environment_holder));
        this.getServices().put(TelemetryService.class, new TelemetryService(this._sdk_environment_holder));
        this.getServices().put(ChatService.class, new ChatService(this._sdk_environment_holder));
        this.getServices().put(CommandService.class, new CommandService(this._sdk_environment_holder));
        this.getServices().put(RecordingService.class, new RecordingService(this._sdk_environment_holder));
        this.getServices().put(NotificationService.class, new NotificationService(this._sdk_environment_holder));
    }
}

