package voxeet.com.sdk.models.abs;

import android.support.annotation.NonNull;

import java.util.Date;
import java.util.List;

import voxeet.com.sdk.models.PSTNItem;
import voxeet.com.sdk.models.RecordingStatus;
import voxeet.com.sdk.models.impl.DefaultConferenceInfos;
import voxeet.com.sdk.models.impl.DefaultConferenceUser;
import voxeet.com.sdk.models.impl.DefaultUserProfile;

/**
 * Created by romainbenmansour on 04/07/16.
 */

public interface Conference {

    interface ConferenceInfo {
        enum ConferenceType {
            STANDARD("STANDARD"),
            SCHEDULED("SCHEDULED"),
            DEMO("DEMO"),
            MEET_NOW("MEET_NOW"),
            REPLAY("REPLAY"),
            USER_CONF("USER_CONF"),
            GUEST("GUEST");

            private final String value;

            ConferenceType(String value) {
                this.value = value;
            }

            public String value() {
                return this.value;
            }

            public static ConferenceType fromId(String value) {
                switch (value) {
                    case "STANDARD":
                        return STANDARD;
                    case "SCHEDULED":
                        return SCHEDULED;
                    case "DEMO":
                        return DEMO;
                    case "MEET_NOW":
                        return MEET_NOW;
                    case "REPLAY":
                        return REPLAY;
                    case "USER_CONF":
                        return USER_CONF;
                    case "GUEST":
                        return GUEST;
                }

                throw new IllegalArgumentException("No econference type with id[" + value + "]");
            }
        }
    }

    String getFallBackNumber();

    DefaultConferenceInfos getConferenceInfos();

    String getTitle();

    String getMeetingId();

    String getLocation();

    String getDescription();

    DefaultUserProfile getOwnerProfile();

    String getPstnPinCode();

    String getConferenceId();

    String getConferenceType();

    String getSecurityToken();

    @NonNull
    List<DefaultConferenceUser> getConferenceUsers();

    int getConferenceRoomSize();

    List<PSTNItem> getPstnItems();

    boolean isOffline();

    boolean isDemo();

    boolean isGuestAccess();

    boolean isRecorded();

    Date getStartRecordTimestamp();

    String getRecordingUser();

    ConferenceUser getUserById(String userId);

    RecordingStatus getRecordingStatus();

    boolean isConferenceEmpty();

    boolean isUsersOnAir();

    boolean hasBeenCreated();

    boolean isObjectValid();
}
