/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.voxeet.promise.Promise;
import com.voxeet.promise.solve.Solver;
import com.voxeet.sdk.VoxeetSdk;
import com.voxeet.sdk.authent.KeySecretThroughOAuthTokenResponseProvider;
import com.voxeet.sdk.authent.OAuthTokenResponseProvider;
import com.voxeet.sdk.authent.endpoints.IVoxeetRService;
import com.voxeet.sdk.authent.models.DeviceType;
import com.voxeet.sdk.authent.models.UserInfoBody;
import com.voxeet.sdk.authent.token.RefreshTokenCallback;
import com.voxeet.sdk.authent.token.TokenResponseProvider;
import com.voxeet.sdk.events.sdk.SocketStateChangeEvent;
import com.voxeet.sdk.exceptions.ExceptionManager;
import com.voxeet.sdk.json.ParticipantInfo;
import com.voxeet.sdk.log.factory.LogFactory;
import com.voxeet.sdk.preferences.VoxeetPreferences;
import com.voxeet.sdk.services.authenticate.VoxeetCookieJar;
import com.voxeet.sdk.services.authenticate.WebSocketState;
import com.voxeet.sdk.services.notification.INotificationTokenProvider;
import com.voxeet.sdk.services.notification.NotificationTokenHolderFactory;
import com.voxeet.sdk.utils.BackendAccessHolder;
import com.voxeet.sdk.utils.converter.JacksonConverterFactory;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.OkHttpClient;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Converter;
import retrofit2.Retrofit;

public class VoxeetHttp {
    private static final String TAG = VoxeetHttp.class.getSimpleName();
    private String serverUrl;
    private String serverPort;
    private Retrofit retrofit;
    private OkHttpClient client;
    private TokenResponseProvider tokenResponseProvider;
    private boolean debug = false;
    private OkHttpClient clientIdentify;
    private OkHttpClient clientSubIdentify;
    private Retrofit retrofitIdentify;
    private Retrofit retrofitSubIdentify;
    private VoxeetCookieJar cookieJar;

    public VoxeetHttp(VoxeetSdk sdk, String serverUrl, String serverPort, BackendAccessHolder holder) {
        this.serverUrl = serverUrl;
        this.serverPort = serverPort;
        String appId = holder.appId;
        String password = holder.password;
        String tokenAccess = holder.tokenAccess;
        RefreshTokenCallback tokenRefresh = holder.tokenRefresh;
        if (null != appId && null != password) {
            Log.d((String)TAG, (String)"VoxeetHttp: initializing using appId/password");
            this.tokenResponseProvider = new KeySecretThroughOAuthTokenResponseProvider(appId, password, sdk.getVoxeetEnvironmentHolder().getVersionName(), sdk.getVoxeetEnvironmentHolder().getServerUrl(), ExceptionManager::sendException);
        } else if (null != tokenRefresh) {
            Log.d((String)TAG, (String)"VoxeetHttp: initializing using access/refresh");
            this.tokenResponseProvider = new OAuthTokenResponseProvider(tokenAccess, tokenRefresh, sdk.getVoxeetEnvironmentHolder().getVersionName(), ExceptionManager::sendException);
        }
        this.initClient();
        this.initRetrofit();
        this.initService();
    }

    private void initClient() {
        this.cookieJar = new VoxeetCookieJar(this.getBuiltServerUrl());
        OkHttpClient.Builder builderIdentify = new OkHttpClient.Builder().cookieJar((CookieJar)this.cookieJar).addNetworkInterceptor(chain -> {
            Log.d((String)TAG, (String)"intercept: builderIdentify");
            return this.tokenResponseProvider.executeIdentify(chain, "builderIdentify");
        });
        OkHttpClient.Builder builderSubIdentify = new OkHttpClient.Builder().cookieJar((CookieJar)this.cookieJar).addNetworkInterceptor(chain -> {
            Log.d((String)TAG, (String)"intercept: builderSubIdentify");
            return this.tokenResponseProvider.executeIdentify(chain, "builderSubIdentify");
        });
        OkHttpClient.Builder builder = new OkHttpClient.Builder().cookieJar((CookieJar)this.cookieJar).addNetworkInterceptor(chain -> {
            Log.d((String)TAG, (String)"intercept: builder");
            return this.tokenResponseProvider.execute(chain);
        });
        this.tokenResponseProvider.configureOkHttpClientBuilder(builder, true);
        this.tokenResponseProvider.configureOkHttpClientBuilder(builderIdentify, true);
        this.tokenResponseProvider.configureOkHttpClientBuilder(builderSubIdentify, false);
        if (this.debug) {
            HostnameVerifier hostnameVerifier = (hostname, session) -> true;
            builder = builder.hostnameVerifier(hostnameVerifier);
            builderIdentify = builderIdentify.hostnameVerifier(hostnameVerifier);
            builderSubIdentify = builderSubIdentify.hostnameVerifier(hostnameVerifier);
        }
        this.client = builder.build();
        this.clientIdentify = builderIdentify.build();
        this.clientSubIdentify = builderSubIdentify.build();
    }

    private void initRetrofit() {
        this.retrofit = new Retrofit.Builder().addConverterFactory((Converter.Factory)JacksonConverterFactory.create(new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES))).baseUrl(this.getBuiltServerUrl()).client(this.client).build();
        this.retrofitIdentify = new Retrofit.Builder().addConverterFactory((Converter.Factory)JacksonConverterFactory.create(new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES))).baseUrl(this.getBuiltServerUrl()).client(this.clientIdentify).build();
        this.retrofitSubIdentify = new Retrofit.Builder().addConverterFactory((Converter.Factory)JacksonConverterFactory.create(new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES))).baseUrl(this.getBuiltServerUrl()).client(this.clientSubIdentify).build();
    }

    private void initService() {
        this.tokenResponseProvider.initService((IVoxeetRService)this.retrofitIdentify.create(IVoxeetRService.class), (IVoxeetRService)this.retrofitSubIdentify.create(IVoxeetRService.class));
    }

    public Promise<Boolean> identifyChain(ParticipantInfo participantInfo) {
        return new Promise(final_solver -> {
            String token;
            LogFactory.instance.connect();
            UserInfoBody userInfoBody = new UserInfoBody(participantInfo.getName(), participantInfo.getExternalId(), participantInfo.getAvatarUrl());
            this.tokenResponseProvider.setUserInfo(userInfoBody);
            VoxeetPreferences.setExternalUserInfo(participantInfo);
            userInfoBody.deviceIdentifier = VoxeetPreferences.deviceIdentifier();
            userInfoBody.deviceType = DeviceType.ANDROID;
            INotificationTokenProvider provider = NotificationTokenHolderFactory.provider;
            if (null != provider && provider.isTokenUploadAllowed() && (token = provider.getToken()) != null) {
                Log.d((String)TAG, (String)"onCall: token obtained");
                userInfoBody.devicePushToken = token;
            }
            this.tokenResponseProvider.retrieve().then(result -> {
                if (null != result) {
                    Log.d((String)TAG, (String)("Successful login with id " + result.getId()));
                    VoxeetPreferences.setId(result.getId());
                    VoxeetPreferences.saveLoginCookie(result.getUserToken());
                    List<Cookie> cookies = this.cookieJar.getCookies(this.getBuiltServerUrl());
                    if (cookies != null && cookies.size() > 0) {
                        VoxeetPreferences.saveLoginCookie(cookies.get(0).toString());
                    }
                    final_solver.resolve((Object)true);
                    VoxeetSdk.session().connectSocket(this);
                } else {
                    EventBus.getDefault().post((Object)new SocketStateChangeEvent(WebSocketState.CLOSED));
                    final_solver.resolve((Object)false);
                }
            }).error(error -> {
                error.printStackTrace();
                ExceptionManager.sendException(error);
                EventBus.getDefault().post((Object)new SocketStateChangeEvent(WebSocketState.CLOSED));
                final_solver.reject(error);
            });
        });
    }

    public Promise<Boolean> logout(@NonNull String id) {
        return new Promise(solver -> this.tokenResponseProvider.logout().then(result -> {
            this.cleanParticipantSession(id);
            solver.resolve(result);
        }).error(arg_0 -> ((Solver)solver).reject(arg_0)));
    }

    public OkHttpClient getClient() {
        return this.client;
    }

    public Retrofit getRetrofit() {
        return this.retrofit;
    }

    @Nullable
    String getToken() {
        return this.tokenResponseProvider.getToken();
    }

    @Nullable
    public String getJwtToken() {
        return this.tokenResponseProvider.getJwtToken();
    }

    public void resetVoxeetHttp() {
        this.tokenResponseProvider.resetVoxeetHttp();
    }

    public void cleanParticipantSession(@NonNull String id) {
        this.tokenResponseProvider.cleanUserSession(id);
    }

    String getBuiltServerUrl() {
        String port = this.serverPort;
        if (!port.startsWith(":")) {
            port = ":" + port;
        }
        return this.serverUrl + port;
    }
}

