/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.sdk.VoxeetSdk;
import com.voxeet.sdk.events.sdk.QualityIndicators;
import com.voxeet.sdk.json.ConferenceStats;
import com.voxeet.sdk.media.MediaSDK;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.models.Participant;
import com.voxeet.sdk.services.AbstractVoxeetService;
import com.voxeet.sdk.services.SdkEnvironmentHolder;
import com.voxeet.sdk.services.holder.ServiceProviderHolder;
import com.voxeet.sdk.services.localstats.LocalStatsHandler;
import com.voxeet.sdk.services.localstats.LocalStatsParticipantInfo;
import com.voxeet.sdk.services.localstats.events.LocalStatsEvent;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;
import com.voxeet.stats.LocalStats;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

@Annotate
public class LocalStatsService
extends AbstractVoxeetService
implements Runnable {
    public static final int NEXT_LOOP_FETCH_MS = 5000;
    private LocalStatsHandler mHandler = null;
    private HashMap<String, HashMap<String, LocalStatsParticipantInfo>> mConferencesHolder = new HashMap();

    @NoDocumentation
    public LocalStatsService(@NonNull SdkEnvironmentHolder instance) {
        super(instance, ServiceProviderHolder.DEFAULT);
    }

    public LocalStatsParticipantInfo getParticipantInfo(@NonNull String conferenceId, @NonNull String participantId) {
        HashMap<String, LocalStatsParticipantInfo> holder = this.getParticipantStatsHolder(conferenceId);
        LocalStatsParticipantInfo info = holder.get(participantId);
        if (null == info) {
            info = new LocalStatsParticipantInfo(participantId);
            holder.put(participantId, info);
        }
        return info;
    }

    @Nullable
    public LocalStats getLocalStats(@Nullable String peer) {
        if (null == peer) {
            return null;
        }
        MediaSDK media = VoxeetSdk.mediaDevice().getMedia();
        if (null != media) {
            return media.getLocalStats(peer);
        }
        return null;
    }

    public boolean startAutoFetch() {
        if (null == this.mHandler) {
            this.mHandler = new LocalStatsHandler(this, 5000L);
            this.mHandler.startAutoFetch();
            return true;
        }
        return false;
    }

    public boolean stopAutoFetch() {
        if (null != this.mHandler) {
            this.mHandler.stopAutoFetch();
            this.mHandler = null;
            return true;
        }
        return false;
    }

    @Override
    @NoDocumentation
    public void run() {
        ArrayList<LocalStats> stats = new ArrayList<LocalStats>();
        Conference conference = VoxeetSdk.conference().getConference();
        if (null != conference) {
            CopyOnWriteArrayList<Participant> users = conference.getParticipants();
            for (int i = 0; i < users.size(); ++i) {
                Participant user = (Participant)users.get(i);
                LocalStats stat = this.getLocalStats(user.getId());
                this.getParticipantInfo(conference.getId(), user.getId()).addFromLocalStats(stat);
                stats.add(stat);
            }
            this.getEventBus().post((Object)new LocalStatsEvent(stats));
        }
    }

    @NonNull
    private HashMap<String, LocalStatsParticipantInfo> getParticipantStatsHolder(@NonNull String conferenceId) {
        HashMap<String, LocalStatsParticipantInfo> holder = this.mConferencesHolder.get(conferenceId);
        if (null == holder) {
            holder = new HashMap();
            this.mConferencesHolder.put(conferenceId, holder);
        }
        return holder;
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceStats stats) {
        String conferenceId = VoxeetSdk.conference().getConferenceId();
        if (stats.getConference_id() != null && stats.getConference_id().equals(conferenceId)) {
            float mos = stats.getScore(VoxeetSdk.session().getParticipantId());
            this.getEventBus().post((Object)new QualityIndicators(mos));
        }
    }
}

