/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.promise.Promise;
import com.voxeet.promise.solve.Solver;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.json.FileConverted;
import com.voxeet.sdk.json.FilePresentationStarted;
import com.voxeet.sdk.json.FilePresentationStopped;
import com.voxeet.sdk.json.FilePresentationUpdated;
import com.voxeet.sdk.models.v1.FilePresentationConverted;
import com.voxeet.sdk.models.v2.ServerErrorOrigin;
import com.voxeet.sdk.network.endpoints.IRestApiFilePresentation;
import com.voxeet.sdk.services.SdkEnvironmentHolder;
import com.voxeet.sdk.services.abstracts.AbstractPresentationService;
import com.voxeet.sdk.services.presentation.PresentationState;
import com.voxeet.sdk.services.presentation.file.FilePresentation;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.HttpHelper;
import com.voxeet.sdk.utils.NoDocumentation;
import com.voxeet.sdk.utils.Opt;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import retrofit2.Response;

@Annotate
public class FilePresentationService
extends AbstractPresentationService<IRestApiFilePresentation, FilePresentation> {
    private static final String TAG = FilePresentationService.class.getSimpleName();
    private HashMap<String, Solver<FilePresentation>> mCacheSolvers = new HashMap();
    private HashMap<String, Solver<FilePresentation>> mCacheStartedSolvers = new HashMap();
    private HashMap<String, Solver<FilePresentation>> mCacheStoppedSolvers = new HashMap();
    private HashMap<String, Solver<FilePresentation>> mCacheUpdatedSolvers = new HashMap();

    @NoDocumentation
    public FilePresentationService(@NonNull SdkEnvironmentHolder instance) {
        super(instance, IRestApiFilePresentation.class);
        this.registerEventBus();
    }

    @NoDocumentation
    void onInternalServiceEvent(FileConverted event) {
        List<com.voxeet.sdk.models.v1.File> list = event.getFiles();
        for (com.voxeet.sdk.models.v1.File file : list) {
            String key = this.findSolverFor(file.getName());
            if (null == key) continue;
            this.onInternalServiceEvent(new FilePresentationConverted(file.getName(), file.getFileId(), file.getSize(), file.getNbImageConverted()));
        }
    }

    @NoDocumentation
    void onInternalServiceEvent(FilePresentationConverted event) {
        FilePresentation information = this.getPresentationInformation(event.fileId);
        this.presentations.add(information);
        information.state = PresentationState.CONVERTED;
        information.page = 0;
        information.nbPage = event.nbImageConverted;
        this.getEventBus().post((Object)event);
        this.tryUnlock(information.key, information, this.mCacheSolvers);
    }

    @NoDocumentation
    void onInternalServiceEvent(FilePresentationStarted event) {
        FilePresentation information = this.getPresentationInformation(event.fileId);
        this.presentations.add(information);
        information.state = PresentationState.STARTED;
        information.page = event.position;
        information.nbPage = event.imageCount;
        this.getEventBus().post((Object)event);
        this.tryUnlock(information.key, information, this.mCacheSolvers);
    }

    @NoDocumentation
    void onInternalServiceEvent(FilePresentationUpdated event) {
        FilePresentation information = this.getPresentationInformation(event.fileId);
        this.presentations.add(information);
        information.state = PresentationState.SEEK;
        information.page = event.position;
        this.getEventBus().post((Object)event);
        this.tryUnlock(information.key, information, this.mCacheSolvers);
    }

    @NoDocumentation
    void onInternalServiceEvent(FilePresentationStopped event) {
        FilePresentation information = this.getPresentationInformation(event.fileId);
        this.presentations.add(information);
        information.state = PresentationState.STOP;
        this.getEventBus().post((Object)event);
        this.tryUnlock(information.key, information, this.mCacheSolvers);
    }

    @NonNull
    public String getImage(String fileId, int pageNumber) {
        return String.format(Locale.getDefault(), "%s/v1/files/%s/converted/%d?token=%s", this.getURLRoot(), fileId, pageNumber, this.getInternalJwtToken());
    }

    @NonNull
    public String getThumbnail(String fileId, int pageNumber) {
        return String.format(Locale.getDefault(), "%s/v1/files/%s/converted/%d/thumbnail?token=%s", this.getURLRoot(), fileId, pageNumber, this.getInternalJwtToken());
    }

    @NonNull
    public Promise<FilePresentation> convertFile(@NonNull File file) {
        return new Promise(solver -> {
            String uuid = UUID.randomUUID().toString();
            String appended_name = uuid + file.getName();
            RequestBody requestFile = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)file);
            MultipartBody.Part body = MultipartBody.Part.createFormData((String)"file", (String)appended_name, (RequestBody)requestFile);
            HttpHelper.promise(((IRestApiFilePresentation)this.getService()).convertFile(requestFile, body), ServerErrorOrigin.CONVERT_FILE).then(result -> {
                Response response = (Response)Opt.of((Object)result).then(c -> c.response).orNull();
                if (((Boolean)Opt.of((Object)response).then(Response::isSuccessful).or((Object)false)).booleanValue()) {
                    this.mCacheSolvers.put(uuid, (Solver<FilePresentation>)solver);
                } else {
                    solver.reject((Throwable)HttpException.throwResponse(response));
                }
            }).error(arg_0 -> ((Solver)solver).reject(arg_0));
        });
    }

    @NonNull
    public Promise<FilePresentation> start(@NonNull FilePresentationConverted body) {
        return this.start(body, 0);
    }

    @NonNull
    public Promise<FilePresentation> start(@NonNull FilePresentationConverted body, int position) {
        return new Promise(solver -> {
            IRestApiFilePresentation.FilePresentationId body_sent = new IRestApiFilePresentation.FilePresentationId(body.fileId, body.name, position, body.nbImageConverted);
            this.consumeInternalCall(solver, body.fileId, this.mCacheStartedSolvers, this.internalCall(((IRestApiFilePresentation)this.getService()).startFilePresentation(this.getConferenceId(), body_sent)));
        });
    }

    @NonNull
    public Promise<FilePresentation> stop(@NonNull String fileId) {
        return new Promise(solver -> {
            IRestApiFilePresentation.FilePresentationId body_sent = new IRestApiFilePresentation.FilePresentationId(fileId);
            this.consumeInternalCall(solver, fileId, this.mCacheStoppedSolvers, this.internalCall(((IRestApiFilePresentation)this.getService()).startFilePresentation(this.getConferenceId(), body_sent)));
        });
    }

    @NonNull
    public Promise<FilePresentation> update(@NonNull String fileId, int position) {
        return new Promise(solver -> {
            IRestApiFilePresentation.FilePresentationId body_sent = new IRestApiFilePresentation.FilePresentationId(fileId, position);
            this.consumeInternalCall(solver, fileId, this.mCacheUpdatedSolvers, this.internalCall(((IRestApiFilePresentation)this.getService()).startFilePresentation(this.getConferenceId(), body_sent)));
        });
    }

    @Nullable
    private String findSolverFor(@NonNull String name) {
        for (String value : this.mCacheSolvers.keySet()) {
            if (name.indexOf(value) != 0) continue;
            return value;
        }
        return null;
    }

    @NonNull
    private FilePresentation getPresentationInformation(@NonNull String key) {
        for (FilePresentation information : this.presentations) {
            if (!key.equals(information.key)) continue;
            return information;
        }
        return new FilePresentation(key, "");
    }
}

