/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services;

import android.support.annotation.NonNull;
import com.voxeet.promise.Promise;
import com.voxeet.sdk.VoxeetSdk;
import com.voxeet.sdk.events.sdk.MessageReceived;
import com.voxeet.sdk.factories.EventsFactory;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.models.Participant;
import com.voxeet.sdk.models.v2.ChatMessage;
import com.voxeet.sdk.services.AbstractVoxeetService;
import com.voxeet.sdk.services.CommandService;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.SdkEnvironmentHolder;
import com.voxeet.sdk.services.SessionService;
import com.voxeet.sdk.services.chat.ChatMessageEvent;
import com.voxeet.sdk.services.chat.InternalChatMessage;
import com.voxeet.sdk.services.holder.ServiceProviderHolder;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

@Annotate
public class ChatService
extends AbstractVoxeetService {
    @NoDocumentation
    public ChatService(@NonNull SdkEnvironmentHolder instance) {
        super(instance, ServiceProviderHolder.DEFAULT);
    }

    @Subscribe
    public void onEvent(MessageReceived event) {
        InternalChatMessage chatMessage = EventsFactory.mapping(event.message, InternalChatMessage.class);
        ConferenceService conferenceService = VoxeetSdk.conference();
        if (null != conferenceService && null != chatMessage) {
            Participant participant = conferenceService.findParticipantById(chatMessage.ownerId);
            EventBus.getDefault().post((Object)new ChatMessageEvent(participant, new ChatMessage(chatMessage)));
        }
    }

    @NonNull
    public Promise<Boolean> sendMessage(@NonNull Conference conference, @NonNull ChatMessage chatMessage) {
        Participant participant;
        InternalChatMessage internalChatMessage;
        String json;
        SessionService sessionService = VoxeetSdk.session();
        CommandService commandService = VoxeetSdk.command();
        if (null != sessionService && null != commandService && null != (json = EventsFactory.getJson(internalChatMessage = new InternalChatMessage("Chat_Message", participant = new Participant(sessionService.getParticipantId(), sessionService.getParticipantInfo()), chatMessage)))) {
            return commandService.send(conference.getId(), json);
        }
        return Promise.reject((Throwable)new IllegalStateException("The sdk is not initialized"));
    }
}

