/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.preferences;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.sdk.json.ParticipantInfo;
import com.voxeet.sdk.preferences.IPreferencesProvider;
import com.voxeet.sdk.preferences.SharedPreferencesCacheWrapper;
import com.voxeet.sdk.utils.AbstractVoxeetEnvironmentHolder;
import java.util.UUID;

public class VoxeetPreferences {
    private static final String TAG = VoxeetPreferences.class.getSimpleName();
    private static final String ACCOUNT_TYPE = "acct_type";
    private static final String ID = "id";
    private static final String DEVICE_ID = "device_id";
    private static final String UPLOAD_TOKEN = "upload_token";
    private static final String LOGIN = "login";
    private static final String COOKIE = "cookie";
    private static final String PASSWORD = "password";
    private static final String APP_VERSION = "app_version";
    private static final String DEFAULT_VIDEO_ON = "default_video_on";
    private static final String DEFAULT_BUILT_IN_SPEAKER_ON = "default_video_on";
    private static final String MANIFEST_URL = "manifest_url";
    private static final String SDK_EXTERNAL_ID = "SDK_INTERNAL_ID";
    private static final String SDK_EXTERNAL_NAME = "SDK_EXTERNAL_NAME";
    private static final String SDK_EXTERNAL_AVATARURL = "SDK_EXTERNAL_AVATARURL";
    private static AbstractVoxeetEnvironmentHolder VoxeetEnvironmentHolder;
    private static IPreferencesProvider preferences;

    private VoxeetPreferences() {
    }

    public static void init(@NonNull Context context, AbstractVoxeetEnvironmentHolder voxeetEnvironmentHolder) {
        VoxeetEnvironmentHolder = voxeetEnvironmentHolder;
        SharedPreferences prefs = context.getSharedPreferences("main", 0);
        VoxeetPreferences.setCustomPreferencesProvider(context, new SharedPreferencesCacheWrapper(prefs));
        if (null == VoxeetPreferences.deviceIdentifier()) {
            VoxeetPreferences.save(DEVICE_ID, UUID.randomUUID().toString());
        }
    }

    public static void setCustomPreferencesProvider(@NonNull Context context, @NonNull IPreferencesProvider provider) {
        int version = 0;
        try {
            version = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)"Error accessing application version number", (Throwable)e);
        }
        preferences = provider;
        preferences.edit().putString(MANIFEST_URL, VoxeetEnvironmentHolder.getManifestUrl()).putInt(APP_VERSION, version).apply();
    }

    @Deprecated
    @Nullable
    public static String id() {
        if (preferences != null && preferences.contains(ID)) {
            return preferences.getString(ID, null);
        }
        return null;
    }

    public static boolean isDefaultVideoOn() {
        return preferences != null && preferences.getBoolean("default_video_on", false);
    }

    public static boolean isDefaultBuiltinSpeakerOn() {
        return preferences != null && preferences.getBoolean("default_video_on", false);
    }

    public static void setDefaultVideoOn(boolean defaultVideoOn) {
        VoxeetPreferences.save("default_video_on", defaultVideoOn);
    }

    public static void setDefaultBuiltInSpeakerOn(boolean defaultBuiltInSpeakerOn) {
        VoxeetPreferences.save("default_video_on", defaultBuiltInSpeakerOn);
    }

    public static void setId(String id) {
        if (preferences != null) {
            preferences.edit().putString(ID, id).apply();
        }
    }

    public static String deviceIdentifier() {
        return preferences.getString(DEVICE_ID, null);
    }

    public static void onLogout() {
        Log.d((String)TAG, (String)"onLogout");
        if (preferences != null) {
            IPreferencesProvider.Editor editor = preferences.edit();
            editor.putString(LOGIN, "").putString(PASSWORD, "").putString(UPLOAD_TOKEN, "").putString(COOKIE, "").putString(ID, "").putString(SDK_EXTERNAL_NAME, null).putString(SDK_EXTERNAL_ID, null).putString(SDK_EXTERNAL_AVATARURL, null).apply();
        }
    }

    public static String getLoginCookie() {
        return preferences.getString(COOKIE, null);
    }

    public static void saveLoginCookie(String cookie) {
        VoxeetPreferences.save(COOKIE, cookie);
    }

    @Nullable
    public static ParticipantInfo getSavedUserInfo() {
        String externalId = VoxeetPreferences.getSdkExternalId();
        String avatarUrl = VoxeetPreferences.getSdkExternalAvatarurl();
        String externalName = VoxeetPreferences.getSdkExternalName();
        if (null != externalId) {
            return new ParticipantInfo(externalName, externalId, avatarUrl);
        }
        return null;
    }

    public static String getSdkExternalId() {
        if (null != preferences) {
            return preferences.getString(SDK_EXTERNAL_ID, null);
        }
        return null;
    }

    public static String getSdkExternalName() {
        if (null != preferences) {
            return preferences.getString(SDK_EXTERNAL_NAME, null);
        }
        return null;
    }

    public static String getSdkExternalAvatarurl() {
        if (null != preferences) {
            return preferences.getString(SDK_EXTERNAL_AVATARURL, null);
        }
        return null;
    }

    public static void setExternalName(String externalName) {
        VoxeetPreferences.save(SDK_EXTERNAL_NAME, externalName);
    }

    public static void setExternalId(String externalId) {
        VoxeetPreferences.save(SDK_EXTERNAL_ID, externalId);
    }

    public static void setExternalAvatarUrl(String externalAvatarUrl) {
        VoxeetPreferences.save(SDK_EXTERNAL_AVATARURL, externalAvatarUrl);
    }

    public static void setExternalUserInfo(@Nullable ParticipantInfo participantInfo) {
        if (null == participantInfo) {
            return;
        }
        VoxeetPreferences.setExternalId(participantInfo.getExternalId());
        VoxeetPreferences.setExternalAvatarUrl(participantInfo.getAvatarUrl());
        VoxeetPreferences.setExternalName(participantInfo.getName());
    }

    private static void save(@NonNull String key, @Nullable String value) {
        if (preferences != null) {
            preferences.edit().putString(key, value).apply();
        }
    }

    private static void save(@NonNull String key, boolean value) {
        if (preferences != null) {
            preferences.edit().putBoolean(key, value).apply();
        }
    }
}

