/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.models.v2;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.android.media.MediaStream;
import com.voxeet.android.media.MediaStreamType;
import com.voxeet.sdk.models.Participant;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;
import java.util.List;

@Annotate
public class ParticipantMediaStreamHandler {
    private Participant participant;

    @NoDocumentation
    public ParticipantMediaStreamHandler(@NonNull Participant participant) {
        this.participant = participant;
    }

    public boolean has(@NonNull MediaStreamType type) {
        for (MediaStream stream : this.participant.streams()) {
            if (!type.equals((Object)stream.getType())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public MediaStream getFirst(@NonNull MediaStreamType type) {
        for (MediaStream stream : this.participant.streams()) {
            if (!type.equals((Object)stream.getType())) continue;
            return stream;
        }
        return null;
    }

    @NonNull
    public Participant insertOrUpdate(@NonNull MediaStream mediaStream) {
        List<MediaStream> streams = this.participant.streams();
        boolean found = false;
        for (MediaStream stream : streams) {
            if (!stream.equals((Object)mediaStream)) continue;
            found = true;
            break;
        }
        if (!found) {
            streams.add(mediaStream);
        } else {
            streams.remove(mediaStream);
            streams.add(mediaStream);
        }
        return this.participant;
    }

    @NonNull
    public Participant removeAllStreams() {
        List<MediaStream> streams = this.participant.streams();
        streams.clear();
        return this.participant;
    }

    @NonNull
    public boolean remove(@NonNull MediaStream mediaStream) {
        List<MediaStream> streams = this.participant.streams();
        return streams.remove(mediaStream);
    }

    @NonNull
    public boolean remove(@NonNull MediaStreamType type) {
        List<MediaStream> streams = this.participant.streams();
        MediaStream toRemove = null;
        for (MediaStream stream : streams) {
            if (!type.equals((Object)stream.getType())) continue;
            toRemove = stream;
            break;
        }
        if (null != toRemove) {
            streams.remove(toRemove);
            return true;
        }
        return false;
    }
}

