/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.media.audio;

import android.content.Context;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.audio.listeners.IAudioRouteListener;
import com.voxeet.audio.utils.Log;
import com.voxeet.audio.utils.__Call;
import com.voxeet.audio2.AudioDeviceManager;
import com.voxeet.audio2.devices.BluetoothDevice;
import com.voxeet.audio2.devices.MediaDevice;
import com.voxeet.audio2.devices.description.ConnectionState;
import com.voxeet.audio2.devices.description.DeviceType;
import com.voxeet.promise.Promise;
import com.voxeet.sdk.events.sdk.AudioRouteChangeEvent;
import com.voxeet.sdk.media.MediaPowerManager;
import com.voxeet.sdk.media.audio.AudioRoute;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.AudioType;
import com.voxeet.sdk.utils.NoDocumentation;
import com.voxeet.sdk.utils.Opt;
import com.voxeet.sdk.utils.SoundPool;
import com.voxeet.sdk.utils.Validate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.greenrobot.eventbus.EventBus;

@Annotate
public class SoundManager
implements IAudioRouteListener {
    private static final String TAG = SoundManager.class.getSimpleName();
    private AudioDeviceManager mAudioDeviceManager;
    private MediaPowerManager mMediaPowerManager;
    private Context mContext;
    private HashMap<Integer, SoundPool> _sound_pools;
    private HashMap<AudioType, String> mSounds;
    private boolean enabled;
    private List<MediaDevice> mediaDevices;
    private MediaDevice current;
    private ArrayList<Call<List<MediaDevice>>> callbacks = new ArrayList();

    private SoundManager() {
        this.disable();
    }

    @NoDocumentation
    public SoundManager(@NonNull Context context) {
        this();
        this.mediaDevices = new ArrayList<MediaDevice>();
        this._sound_pools = new HashMap();
        this.mAudioDeviceManager = new AudioDeviceManager(context, this::updateDevices);
        this.mMediaPowerManager = new MediaPowerManager(context, this.currentRoute());
        this.mContext = context;
        this.mSounds = new HashMap();
        this.configure();
    }

    public boolean registerUpdateDevices(Call<List<MediaDevice>> callback) {
        if (!this.callbacks.contains(callback)) {
            this.callbacks.add(callback);
            return true;
        }
        return false;
    }

    public void unregisterUpdateDevices(Call<List<MediaDevice>> callback) {
        this.callbacks.remove(callback);
    }

    private void updateDevices(Promise<List<MediaDevice>> update) {
        update.then(mediaDevices -> {
            this.mediaDevices = mediaDevices;
            this.mMediaPowerManager.setAudioRoute(this.currentRoute());
            return this.mAudioDeviceManager.current();
        }).then(current -> {
            this.current = current;
            for (Call<List<MediaDevice>> callback : this.callbacks) {
                try {
                    callback.apply(this.mediaDevices);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).error(Throwable::printStackTrace);
    }

    @NonNull
    public List<AudioRoute> getAvailableRoutes() {
        ArrayList<AudioRoute> routes = new ArrayList<AudioRoute>();
        for (MediaDevice device : this.mediaDevices) {
            AudioRoute route = AudioRoute.from(device);
            if (routes.contains((Object)route)) continue;
            routes.add(route);
        }
        return routes;
    }

    @NonNull
    public AudioRoute currentRoute() {
        if (null != this.current) {
            return AudioRoute.from(this.current);
        }
        return AudioRoute.ROUTE_MEDIA;
    }

    @NonNull
    public Promise<List<MediaDevice>> enumerateDevices() {
        return this.mAudioDeviceManager.enumerateDevices();
    }

    @NonNull
    public Promise<Boolean> connect(@NonNull MediaDevice device) {
        return this.mAudioDeviceManager.connect(device);
    }

    @NonNull
    public Promise<Boolean> disconnect(@NonNull MediaDevice device) {
        return this.mAudioDeviceManager.disconnect(device);
    }

    @Deprecated
    public boolean setAudioRoute(@NonNull AudioRoute route) {
        Validate.runningOnUiThread();
        MediaDevice device = this.oneOf(route);
        if (null != device) {
            this._connect(device, "setAudioRoute to " + device.id());
            return true;
        }
        return false;
    }

    @Nullable
    public Ringtone getSystemRingtone() {
        Uri uri = RingtoneManager.getDefaultUri((int)1);
        if (null == uri) {
            return null;
        }
        return RingtoneManager.getRingtone((Context)this.mContext, (Uri)uri);
    }

    public boolean isBluetoothHeadsetConnected() {
        return this.isPlatformConnected(DeviceType.BLUETOOTH, ConnectionState.CONNECTED);
    }

    public boolean isWiredHeadsetOn() {
        return this.isPlatformConnected(DeviceType.WIRED_HEADSET, ConnectionState.CONNECTED);
    }

    public boolean isPlatformConnected(@NonNull DeviceType deviceType, @NonNull ConnectionState state) {
        return (Boolean)Opt.of((Object)this.oneOf(deviceType)).then(c -> state.equals((Object)c.platformConnectionState())).or((Object)false);
    }

    @Deprecated
    @NonNull
    public SoundManager setSpeakerMode(boolean isSpeaker) {
        MediaDevice[] devices;
        MediaDevice toConnect = null;
        Log.d((String)TAG, (String)("setSpeakerMode: enabled ?" + this.enabled));
        for (MediaDevice device : devices = new MediaDevice[]{this.oneOf(DeviceType.WIRED_HEADSET), this.oneOf(DeviceType.BLUETOOTH)}) {
            if (toConnect != null || null == device || !ConnectionState.CONNECTED.equals((Object)device.platformConnectionState())) continue;
            toConnect = device;
        }
        if (null == toConnect) {
            toConnect = this.oneOf(isSpeaker ? DeviceType.EXTERNAL_SPEAKER : DeviceType.INTERNAL_SPEAKER);
        }
        if (null != toConnect) {
            this._connect(toConnect, "setSpeakerMode for " + toConnect.id());
        } else {
            Log.d((String)TAG, (String)"unexpected null for setSpeakerMode !!");
        }
        return this;
    }

    @Deprecated
    public boolean isSpeakerOn() {
        return (Boolean)Opt.of((Object)this.oneOf(AudioRoute.ROUTE_SPEAKER)).then(c -> ConnectionState.CONNECTED.equals((Object)c.connectionState())).or((Object)false);
    }

    @NonNull
    public SoundManager acquireLocks() {
        this.mMediaPowerManager.acquire();
        return this;
    }

    @NonNull
    public SoundManager releaseLocks() {
        this.mMediaPowerManager.release();
        return this;
    }

    @NonNull
    public SoundManager resetDefaultSoundType() {
        this.abandonAudioFocusRequest();
        return this;
    }

    private int getUiSoundsStreamType() {
        return 3;
    }

    @NonNull
    public SoundManager enableMedia() {
        this.enabled = true;
        this.setMediaRoute();
        return this;
    }

    @NonNull
    public SoundManager setMediaRoute() {
        MediaDevice device = this.oneOf(AudioRoute.ROUTE_MEDIA);
        if (null != device) {
            this._connect(device, "setMediaRoute connect for " + device.id() + " done");
        }
        return this;
    }

    @Deprecated
    @NonNull
    public SoundManager unsetMediaRoute() {
        MediaDevice device = this.oneOf(AudioRoute.ROUTE_MEDIA);
        if (null != device) {
            this.mAudioDeviceManager.disconnect(device).then(result -> Log.d((String)TAG, (String)("connect for " + device.id() + " done ? " + result))).error(Throwable::printStackTrace);
        }
        return this;
    }

    @NonNull
    public SoundManager abandonAudioFocusRequest() {
        this.mAudioDeviceManager.current().then(mediaDevice -> {
            if (null != mediaDevice) {
                return this.mAudioDeviceManager.disconnect(mediaDevice);
            }
            return Promise.resolve((Object)true);
        }).then(result -> Log.d((String)TAG, (String)"abandonAudioFocusRequest done")).error(Throwable::printStackTrace);
        return this;
    }

    @NonNull
    public SoundManager requestAudioFocus() {
        this.mAudioDeviceManager.current().then(current -> (Promise)Opt.of((Object)current).then(c -> this.mAudioDeviceManager.connect(c)).or((Object)Promise.resolve((Object)true))).then(result -> Log.d((String)TAG, (String)"requestAudioFocus done")).error(Throwable::printStackTrace);
        return this;
    }

    @NonNull
    public SoundManager checkOutputRoute() {
        if (this.isEnabled()) {
            Log.d((String)TAG, (String)"check the current route ! will call reconnect of the current connected device");
            this.requestAudioFocus();
        }
        return this;
    }

    private SoundPool getSoundPool(int soundMode) {
        SoundPool pool = this._sound_pools.get(soundMode);
        if (pool == null) {
            pool = new SoundPool(this.mContext, soundMode, this.getVolume(soundMode));
            this._sound_pools.put(soundMode, pool);
        }
        return pool;
    }

    private void configure() {
        this.mAudioDeviceManager.enumerateDevices().then(mediaDevices -> {
            this.mediaDevices = mediaDevices;
        }).error(Throwable::printStackTrace);
        this.enabled = false;
        this.mSounds.put(AudioType.RING, "out.mp3");
        this.mSounds.put(AudioType.HANGUP, "leave.mp3");
        this.setSound(AudioType.RING, this.mSounds.get((Object)AudioType.RING));
        this.setSound(AudioType.HANGUP, this.mSounds.get((Object)AudioType.HANGUP));
    }

    public boolean setSound(@NonNull AudioType type, @NonNull String assetName) {
        return this.setSound(type, assetName, 0);
    }

    public boolean setSound(@NonNull AudioType type, @NonNull String assetName, int soundMode) {
        return this.getSoundPool(soundMode).release(type).setShortResource(type, assetName);
    }

    @NonNull
    public SoundManager playSoundType(@NonNull AudioType type) {
        return this.playSoundType(type, 0);
    }

    @NonNull
    public SoundManager playSoundType(@NonNull AudioType type, int soundMode) {
        if (this.isEnabled()) {
            this.getSoundPool(soundMode).playShortResource(type, this.mSounds.get((Object)type));
        }
        return this;
    }

    @NonNull
    public SoundManager playSoundTypeForce(@NonNull AudioType type) {
        return this.playSoundType(type, 0);
    }

    @NonNull
    public SoundManager playSoundTypeForce(@NonNull AudioType type, int soundMode) {
        this.getSoundPool(soundMode).playShortResource(type, this.mSounds.get((Object)type));
        return this;
    }

    @NonNull
    public SoundManager stopSoundType(@NonNull AudioType audioType) {
        return this.stopSoundType(audioType, 0);
    }

    @NonNull
    public SoundManager stopSoundType(@NonNull AudioType audioType, int soundMode) {
        this.getSoundPool(soundMode).stop(audioType);
        return this;
    }

    @NonNull
    public SoundManager stop(int soundMode) {
        this.getSoundPool(soundMode).stop();
        return this;
    }

    @NonNull
    public SoundManager stop() {
        this.stop(0);
        return this;
    }

    @NonNull
    public SoundManager onConferencePreJoinedEvent() {
        MediaDevice[] devices;
        for (MediaDevice device : devices = new MediaDevice[]{this.oneOf(DeviceType.BLUETOOTH), this.oneOf(DeviceType.WIRED_HEADSET), this.oneOf(DeviceType.EXTERNAL_SPEAKER), this.oneOf(DeviceType.INTERNAL_SPEAKER)}) {
            if (null == device || !ConnectionState.CONNECTED.equals((Object)device.platformConnectionState())) continue;
            this._connect(device, "onConferencePreJoinedEvent done ");
        }
        return this;
    }

    private void _connect(@NonNull MediaDevice device, String text) {
        this.mAudioDeviceManager.connect(device).then(result -> Log.d((String)TAG, (String)(text + " ? " + result))).error(Throwable::printStackTrace);
    }

    @NonNull
    public SoundManager onConferenceDestroyedPush() {
        this.abandonAudioFocusRequest();
        return this;
    }

    @NonNull
    public SoundManager enable() {
        this.enabled = true;
        return this;
    }

    @NonNull
    public SoundManager disable() {
        this.enabled = false;
        return this;
    }

    private boolean isEnabled() {
        return this.enabled;
    }

    private float getVolume(int soundMode) {
        if (soundMode == 0) {
            return 0.1f;
        }
        return 1.0f;
    }

    @NoDocumentation
    public void onAudioRouteChanged() {
        EventBus.getDefault().post((Object)new AudioRouteChangeEvent());
    }

    @Nullable
    public MediaDevice oneOf(@NonNull AudioRoute route) {
        for (MediaDevice device : this.mediaDevices) {
            if (!route.isCompatible(device) || !this.isNotFiltered(device)) continue;
            return device;
        }
        return null;
    }

    @Nullable
    public MediaDevice oneOf(@NonNull DeviceType deviceType) {
        for (MediaDevice device : this.mediaDevices) {
            if (!deviceType.equals((Object)device.deviceType()) || !this.isNotFiltered(device)) continue;
            return device;
        }
        return null;
    }

    public boolean isNotFiltered(@NonNull MediaDevice device) {
        if (device instanceof BluetoothDevice) {
            android.bluetooth.BluetoothDevice bt = ((BluetoothDevice)device).bluetoothDevice();
            return (Boolean)Opt.of((Object)bt).then(android.bluetooth.BluetoothDevice::getName).then(String::toLowerCase).then(s -> !s.contains("watch")).or((Object)false);
        }
        return true;
    }

    public Promise<MediaDevice> current() {
        return Promise.resolve((Object)this.current);
    }

    public static interface Call<TYPE>
    extends __Call<TYPE> {
    }
}

