/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.json;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.json.Event;
import com.voxeet.sdk.json.ParticipantInfo;
import com.voxeet.sdk.models.Participant;
import com.voxeet.sdk.models.v1.Conference;
import com.voxeet.sdk.models.v1.ConferenceType;
import com.voxeet.sdk.utils.FromWebsocket;
import com.voxeet.sdk.utils.InternalEvent;
import com.voxeet.sdk.utils.Opt;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeName(value="InvitationReceivedEvent")
@InternalEvent
@FromWebsocket
public class InvitationReceivedEvent
extends Event {
    public String conferenceId;
    @JsonProperty(value="confAlias")
    @Nullable
    public String conferenceAlias;
    @JsonProperty(value="userId")
    @Nullable
    public String userId;
    @JsonProperty(value="participantId")
    @Nullable
    public String participantId;
    @JsonProperty(value="externalId")
    @Nullable
    public String externalId;
    @JsonProperty(value="externalName")
    @Nullable
    public String externalName;
    @JsonProperty(value="externalAvatarUrl")
    public String externalAvatarUrl;
    @Nullable
    public ParticipantInviter inviter;
    @JsonProperty(value="conferenceInfo")
    @Nullable
    public Conference conference;

    @Override
    public String getType() {
        return "InvitationReceivedEvent";
    }

    @NonNull
    public Participant getInviter() {
        String id = (String)Opt.of((Object)this.participantId).or((Object)this.userId);
        String externalId = (String)Opt.of((Object)this.externalId).orNull();
        String avatarUrl = (String)Opt.of((Object)this.externalAvatarUrl).orNull();
        String userName = (String)Opt.of((Object)this.externalName).orNull();
        if (null != this.inviter) {
            if (TextUtils.isEmpty((CharSequence)id)) {
                id = (String)Opt.of((Object)this.inviter.participantId).orNull();
            }
            if (TextUtils.isEmpty((CharSequence)externalId)) {
                externalId = (String)Opt.of((Object)this.inviter.externalId).orNull();
            }
            if (TextUtils.isEmpty((CharSequence)userName)) {
                userName = (String)Opt.of((Object)this.inviter.externalName).or(Opt.of((Object)this.inviter.nickName).or((Object)""));
            }
            if (TextUtils.isEmpty((CharSequence)avatarUrl)) {
                avatarUrl = (String)Opt.of((Object)this.inviter.externalAvatarUrl).orNull();
            }
        }
        if (TextUtils.isEmpty((CharSequence)id)) {
            id = "";
        }
        if (TextUtils.isEmpty((CharSequence)externalId)) {
            externalId = "";
        }
        if (TextUtils.isEmpty((CharSequence)userName)) {
            userName = "";
        }
        if (TextUtils.isEmpty((CharSequence)avatarUrl)) {
            avatarUrl = "";
        }
        return new Participant(id, new ParticipantInfo(userName, externalId, avatarUrl));
    }

    @NonNull
    public String id() {
        String conferenceId;
        if (!TextUtils.isEmpty((CharSequence)this.conferenceId)) {
            return this.conferenceId;
        }
        if (null != this.conference && null != (conferenceId = this.conference.getConferenceId())) {
            return conferenceId;
        }
        return "";
    }

    @NonNull
    public ConferenceType type() {
        if (null != this.conference && null != this.conference.getConferenceType()) {
            return ConferenceType.fromId(this.conference.getConferenceType());
        }
        return ConferenceType.SDK_CONF;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public class ParticipantInviter {
        @JsonProperty(value="userId")
        @Nullable
        public String participantId;
        @Nullable
        public String externalId;
        @Nullable
        public String externalAvatarUrl;
        @Nullable
        public String externalName;
        @Nullable
        public String nickName;

        public ParticipantInviter() {
        }

        public ParticipantInviter(String participantId, String externalId, String externalAvatarUrl, String externalName) {
            this();
            this.participantId = participantId;
            this.externalId = externalId;
            this.externalAvatarUrl = externalAvatarUrl;
            this.externalName = externalName;
            this.nickName = externalName;
        }
    }
}

