package com.voxeet.sdk.utils;

import android.support.annotation.NonNull;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Stream<TYPE> {
    @NonNull
    private final Collection<TYPE> collection;

    private Stream() {
        collection = new ArrayList<>();
    }

    private Stream(@NonNull Collection<TYPE> collec) {
        this.collection = collec;
    }

    public Stream of(@NonNull Collection<TYPE> collec) {
        return new Stream(collec);
    }

    public <OUT> Collection<OUT> map(MapCallback<TYPE, OUT> apply) {
        List<OUT> out = new ArrayList<>();
        for (TYPE in : collection) {
            out.add(apply.apply(in));
        }
        return out;
    }
}
