package com.voxeet.sdk.utils;

import java.util.ArrayList;
import java.util.List;

public class Filter {
    public static <ITEM> List<ITEM> filter(List<ITEM> list, Valid<ITEM> callback) {
        List<ITEM> new_list = new ArrayList<>();

        for (ITEM item : list) {
            if (callback.isValid(item)) new_list.add(item);
        }

        return new_list;
    }

    public static interface Valid<ITEM> {
        boolean isValid(ITEM t);
    }
}
