package com.voxeet.sdk.utils;

/**
 * The AudioType model [checks](/documentation/sdk/reference/android/models/audiotype#isloop) if the specific type of audio is used in the auto looping mode.
 */
@Annotate
public enum AudioType {
    RING(true),
    HANGUP(false),
    CUSTOM1(false),
    CUSTOM2(false),
    CUSTOM3(false),
    CUSTOM4(false),
    CUSTOM5(false),
    CUSTOM6(false),
    CUSTOM7(false),
    CUSTOM8(false),
    CUSTOM9(false),
    CUSTOM10(false),
    CUSTOM11(false),
    CUSTOM12(false),
    CUSTOM_LOOP_1(true),
    CUSTOM_LOOP_2(true),
    CUSTOM_LOOP_3(true),
    CUSTOM_LOOP_4(true);

    private final boolean loop;

    @NoDocumentation
    AudioType(boolean loop) {
        this.loop = loop;
    }
    
    /**
     * Checks if the specific type of audio is used in a loop. Before calling this method, stop it manually first.
     *
     * @return the looping state.
     */
    public boolean isLoop() {
        return loop;
    }
}
