package com.voxeet.sdk.services.notification;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.sdk.utils.Annotate;

/**
 * The INotificationTokenProvider model [provides](/documentation/sdk/reference/android/models/inotificationtokenprovider#gettoken) the firebase push notification token (currently the only one supported by Voxeet). The token can be invalid. It is also responsible for informing if it is [allowed to upload the token](/documentation/sdk/reference/android/models/inotificationtokenprovider#istokenuploadallowed), and it [logs](/documentation/sdk/reference/android/models/inotificationtokenprovider#log) strings related to notifications.
 *
 * Available in the package _com.voxeet.sdk.core.services.notification.INotificationTokenProvider_.
 */
@Annotate
public interface INotificationTokenProvider {

    /**
     * The Firebase token obtained through the SDK Firebase.
     * @return its value or a null value if the implementation does not communicate it.
     */
    @Nullable
    String getToken();

    /**
     * Informs that the SDK uploads the token to Voxeet.
     *
     * @return the permission flag.
     */
    boolean isTokenUploadAllowed();

    /**
     * Logs strings related to notifications.
     *
     * @param log The string to login to the logcat bridge.
     */
    void log(@NonNull String log);
}
