package com.voxeet.sdk.services.conference;

import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * The ConferenceConfigurations model introduces the [ConferenceConfigurations](/documentation/sdk/reference/android/models/conferenceconfigurations#conferenceconfigurations) constructor. It enables checking default values, such as the [audio route for conferences](/documentation/sdk/reference/android/models/conferenceconfigurations#isdefaultonspeaker-boolean), [video](/documentation/sdk/reference/android/models/conferenceconfigurations#isdefaultvideo-boolean), or the [microphone state](/documentation/sdk/reference/android/models/conferenceconfigurations#isdefaultmute-boolean).
 * It also contains information about telecom [timeout while waiting for other participants](/documentation/sdk/reference/android/models/conferenceconfigurations#telecomwaitingforparticipanttimeout-long), [mode prefix](/documentation/sdk/reference/android/models/conferenceconfigurations#automatictelecommodeprefix-string), and [mode](/documentation/sdk/reference/android/models/conferenceconfigurations#telecommode-boolean).
 */
@Annotate
public class ConferenceConfigurations {
    /**
     * Includes the optional timeout after which, if nobody joined it, the conference is automatically left.
     */
    public long TelecomWaitingForParticipantTimeout = -1;

    /**
     * Informs about the requested default audio route.
     */
    public boolean isDefaultOnSpeaker = false;

    /**
     * Informs about the requested default video.
     */
    public boolean isDefaultVideo = false;

    /**
     * Informs about the requested default mute and unmuted microphone state.
     */
    public boolean isDefaultMute = false;

    /**
     * Automatically sets telecom mode based on a given conference alias. For example, all "telecom_XXXXXX" conference aliases are considered telecom modes that enabled conferences.
     *
     * Putting a non-null value valid in the field triggers telecom mode only when it is needed. It does not change the overall flag.
     *
     * This property is helpful in push notification invitations. It can be used with the following metadata in your application manifest:
     * <meta-data android:name="voxeet_automatic_telecom_conference_alias_prefix"
     * android:value="someprefix" />
     */
    @NoDocumentation
    public String automaticTelecomModePrefix = null;

    /**
     * Informs about the default telecom mode for conferences.
     */
    @NoDocumentation
    public boolean telecomMode = false;

    @NoDocumentation
    public boolean isICERestartEnabled;
}
