package com.voxeet.sdk.preferences;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

public interface IPreferencesProvider {


    Editor edit();

    String getString(@NonNull String key, @Nullable String def);

    boolean getBoolean(@NonNull String key, boolean def);

    int getInt(@NonNull String key, int def);

    long getLong(@NonNull String key, long def);

    boolean contains(@NonNull String key);


    interface Editor {
        Editor putString(@NonNull String key, @Nullable String value);

        Editor putLong(@NonNull String key, long value);

        Editor putBoolean(@NonNull String key, boolean value);

        Editor putInt(@NonNull String key, int value);

        void apply();
    }
}
