package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.ToDelete;

@ToDelete
@Annotate
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.SDK_CONFERENCE_CREATED)
public class SdkConferenceCreated extends Event {

    private String conferenceId;

    public SdkConferenceCreated() {
    }

    public SdkConferenceCreated(String conferenceId) {
        this.conferenceId = conferenceId;
    }

    public String getConferenceId() {
        return conferenceId;
    }

    public void setConferenceId(String conferenceId) {
        this.conferenceId = conferenceId;
    }

    @Override
    public String getType() {
        return EventNames.SDK_CONFERENCE_CREATED;
    }
}
