package com.voxeet.sdk.events.sdk;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.services.conference.information.ConferenceStatus;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromSDK;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * Event fired when the given Conference has a new state.
 */
@Annotate
@FromSDK
public class ConferenceStatusUpdatedEvent {

    /**
     * The corresponding state
     */
    @NonNull
    public ConferenceStatus state = ConferenceStatus.DEFAULT;

    /**
     * The impacted conference. Can be null if the Conference has not been joined already but the conference alias will be valid.
     */
    @Nullable
    public Conference conference;

    /**
     * The conference alias. This field is mandatory when it's concerning a non-joined Conference
     */
    @Nullable
    public String conferenceAlias;

    @NoDocumentation
    public ConferenceStatusUpdatedEvent() {

    }

    @NoDocumentation
    public ConferenceStatusUpdatedEvent(@Nullable String conferenceAlias, @NonNull ConferenceStatus state) {
        this.conferenceAlias = conferenceAlias;
        this.state = state;
    }

    @NoDocumentation
    public ConferenceStatusUpdatedEvent(@NonNull Conference conference, @NonNull ConferenceStatus state) {
        this.conference = conference;
        this.conferenceAlias = conference.getAlias();
        this.state = state;
    }
}
