package com.voxeet.sdk.events.sdk;

import android.support.annotation.NonNull;

import com.voxeet.sdk.events.SuccessEvent;
import com.voxeet.sdk.models.v1.ConferenceUser;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromSDK;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * Emitted when the application asked about the list of participants invited to the conference.
 */
@Annotate
@FromSDK
public class ConferenceParticipantsInvitedResult extends SuccessEvent {

    /**
     * A list of invited `ConferenceUser`
     */
    @NonNull
    public Iterable<ConferenceUser> conferenceParticipants;

    @NoDocumentation
    public ConferenceParticipantsInvitedResult(@NonNull Iterable<ConferenceUser> conferenceParticipants) {
        this.conferenceParticipants = conferenceParticipants;
    }
}
