package com.voxeet.sdk.events.promises;

import android.support.annotation.NonNull;

import com.voxeet.sdk.events.error.PermissionRefusedEvent;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * The PromisePermissionRefusedEventException model is an exception that is sent when there is an API call that requires the specific participant to grant permission.
 */
@Annotate
public class PromisePermissionRefusedEventException extends Throwable {

    /**
     * Contains information about the missing permission.
     */
    @NonNull
    public PermissionRefusedEvent event;

    @NoDocumentation
    public PromisePermissionRefusedEventException() {
        super();
    }

    @NoDocumentation
    public PromisePermissionRefusedEventException(@NonNull PermissionRefusedEvent event) {
        this();

        this.event = event;
    }
}
