/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.promise.Promise;
import com.voxeet.promise.solve.Solver;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.models.v2.ServerErrorOrigin;
import com.voxeet.sdk.network.endpoints.IRestApiSimulcast;
import com.voxeet.sdk.services.AbstractPromiseable;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.services.simulcast.ParticipantQuality;
import com.voxeet.sdk.utils.HttpHelper;
import com.voxeet.sdk.utils.Opt;
import java.util.List;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;

public class SimulcastPromiseable
extends AbstractPromiseable<Boolean, IRestApiSimulcast> {
    private final String conferenceId;
    private List<ParticipantQuality> requested = null;

    public SimulcastPromiseable(@NonNull ConferenceService parent, @NonNull MediaDeviceService mediaDeviceService, @NonNull IRestApiSimulcast provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus, @Nullable List<ParticipantQuality> requested) {
        super(parent, mediaDeviceService, provider, information, eventBus);
        this.conferenceId = (String)Opt.of((Object)information).then(ConferenceInformation::getConference).then(Conference::getId).or((Object)"");
        this.requested = requested;
    }

    @Override
    @NonNull
    public Promise<Boolean> createPromise() {
        return new Promise(solver -> {
            Call<Boolean> observable = ((IRestApiSimulcast)this.getApiRestCall()).simulcast(this.conferenceId, new IRestApiSimulcast.ParticipantExpectedQualityBody(this.requested));
            HttpHelper.promise(observable, ServerErrorOrigin.SIMULCAST).then(answer -> {
                int code = (Integer)Opt.of((Object)answer).then(a -> a.response).then(Response::code).or((Object)400);
                solver.resolve((Object)(code >= 200 && code < 300 ? 1 : 0));
            }).error(arg_0 -> ((Solver)solver).reject(arg_0));
        });
    }
}

