/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.promise.Promise;
import com.voxeet.promise.solve.ErrorPromise;
import com.voxeet.promise.solve.PromiseExec;
import com.voxeet.promise.solve.PromiseSolver;
import com.voxeet.promise.solve.Solver;
import com.voxeet.sdk.VoxeetSdk;
import com.voxeet.sdk.events.sdk.ConferenceStatusUpdatedEvent;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.network.endpoints.IRestApiConferenceAccess;
import com.voxeet.sdk.services.AbstractPromiseable;
import com.voxeet.sdk.services.AudioService;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.services.conference.information.ConferenceParticipantType;
import com.voxeet.sdk.services.conference.information.ConferenceStatus;
import com.voxeet.sdk.services.conference.information.LocalConferenceType;
import org.greenrobot.eventbus.EventBus;

public class JoinPromise
extends AbstractPromiseable<Conference, IRestApiConferenceAccess> {
    private static final String TAG = JoinPromise.class.getSimpleName();
    private final String conferenceId;
    private final ConferenceParticipantType userType;
    private AudioService audioService;

    public JoinPromise(@NonNull ConferenceService parent, @NonNull AudioService audioService, @NonNull MediaDeviceService mediaDeviceService, @NonNull IRestApiConferenceAccess provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus, @NonNull VoxeetSdk instance, @NonNull String conferenceId, @NonNull ConferenceParticipantType userType) {
        super(parent, mediaDeviceService, provider, information, eventBus);
        this.audioService = audioService;
        this.conferenceId = conferenceId;
        this.userType = userType;
    }

    @Override
    @NonNull
    public Promise<Conference> createPromise() {
        final Promise promise = new Promise((PromiseSolver)new PromiseSolver<Conference>(){

            public void onCall(final @NonNull Solver<Conference> solver) {
                boolean init_done;
                JoinPromise.this.joinLock();
                final ConferenceInformation information = JoinPromise.this.createOrSetConferenceWithParams(JoinPromise.this.conferenceId, null);
                information.setConferenceParticipantType(JoinPromise.this.userType);
                String currentConferenceId = JoinPromise.this.getParent().getConferenceId();
                ConferenceInformation holder = JoinPromise.this.getConferenceInformation(JoinPromise.this.conferenceId);
                boolean bl = init_done = ConferenceStatus.JOINING.equals((Object)holder.getConferenceState()) || ConferenceStatus.JOINED.equals((Object)holder.getConferenceState());
                if (null != currentConferenceId && currentConferenceId.equals(JoinPromise.this.conferenceId) && init_done) {
                    Log.d((String)TAG, (String)("onCall: join the conference " + JoinPromise.this.conferenceId + " // invalid call ! already calling it"));
                    Log.d((String)TAG, (String)("onCall: btw, the current " + JoinPromise.this.conferenceId + " state is := " + (Object)((Object)holder.getConferenceState())));
                    solver.resolve((Object)holder.getConference());
                    JoinPromise.this.joinUnlock();
                    return;
                }
                JoinPromise.this.setIsInConference(true);
                final Conference conference = holder.getConference();
                Log.d((String)TAG, (String)("Attempting to join conference alias:=" + conference.getAlias() + " conferenceId:=" + JoinPromise.this.conferenceId));
                Log.d((String)TAG, (String)"onNext: having conference");
                JoinPromise.this.audioService.enable();
                information.setConferenceState(ConferenceStatus.JOINING);
                information.setConferenceType(LocalConferenceType.CONFERENCE);
                information.setTelecomMode(((JoinPromise)JoinPromise.this).getParent().ConferenceConfigurations.telecomMode);
                Log.d((String)TAG, (String)("onNext: join with := " + conference.getId() + " " + conference.getAlias()));
                JoinPromise.this.joinUnlock();
                JoinPromise.this.setCurrentConferenceIfNotInPreviousConference(information);
                JoinPromise.this.joinConference(information).then((PromiseExec)new PromiseExec<Conference, Object>(){

                    public void onCall(@Nullable Conference result, @NonNull Solver<Object> internal_solver) {
                        Log.d((String)TAG, (String)("onCall: joinConference done " + result));
                        solver.resolve((Object)result);
                    }
                }).error(new ErrorPromise(){

                    public void onError(@NonNull Throwable error) {
                        information.setConferenceState(ConferenceStatus.ERROR);
                        ConferenceStatusUpdatedEvent event = new ConferenceStatusUpdatedEvent(conference, conference.getState());
                        JoinPromise.this.getEventBus().post((Object)event);
                        error.printStackTrace();
                        solver.reject(error);
                    }
                });
            }
        });
        if (VoxeetSdk.session().isSocketOpen()) {
            return promise;
        }
        return new Promise((PromiseSolver)new PromiseSolver<Conference>(){

            public void onCall(final @NonNull Solver<Conference> solver) {
                Log.d((String)TAG, (String)"onCall: joining but the socket is disconnected");
                VoxeetSdk.session().open().then((PromiseExec)new PromiseExec<Boolean, Object>(){

                    public void onCall(@Nullable Boolean result, @NonNull Solver internal_solver) {
                        Log.d((String)TAG, (String)("onCall: connection ? " + result));
                        promise.then((PromiseExec)new PromiseExec<Conference, Object>(){

                            public void onCall(@Nullable Conference result, @NonNull Solver<Object> internal_solver) {
                                Log.d((String)TAG, (String)("onCall: join ok? " + result));
                                solver.resolve((Object)result);
                            }
                        }).error(new ErrorPromise(){

                            public void onError(@NonNull Throwable error) {
                                Log.d((String)TAG, (String)"onError: join ko");
                                solver.reject(error);
                            }
                        });
                    }
                }).error(new ErrorPromise(){

                    public void onError(@NonNull Throwable error) {
                        solver.reject(error);
                    }
                });
            }
        });
    }
}

