/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.promise.Promise;
import com.voxeet.sdk.events.error.GetConferenceStatusErrorEvent;
import com.voxeet.sdk.events.promises.PromiseGetConferenceStatusErrorEventException;
import com.voxeet.sdk.events.restapi.ConferenceStatusResult;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.models.v1.ConferenceUser;
import com.voxeet.sdk.models.v2.ServerErrorOrigin;
import com.voxeet.sdk.network.endpoints.IRestApiOutConference;
import com.voxeet.sdk.services.AbstractPromiseable;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.utils.HttpHelper;
import com.voxeet.sdk.utils.Opt;
import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;

public class GetConferenceStatusPromiseable
extends AbstractPromiseable<ConferenceStatusResult, IRestApiOutConference> {
    public GetConferenceStatusPromiseable(@NonNull ConferenceService parent, @NonNull MediaDeviceService mediaDeviceService, @NonNull IRestApiOutConference provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaDeviceService, provider, information, eventBus);
    }

    @Override
    @NonNull
    public Promise<ConferenceStatusResult> createPromise() {
        return new Promise(solver -> {
            String id = (String)Opt.of((Object)this.getInformation()).then(ConferenceInformation::getConference).then(Conference::getId).or((Object)"");
            Call<ConferenceStatusResult> user = ((IRestApiOutConference)this.getApiRestCall()).conferenceStatus(id);
            HttpHelper.promise(user, ServerErrorOrigin.CONFERENCE_STATUS).then(answer -> {
                ConferenceStatusResult object = (ConferenceStatusResult)Opt.of((Object)answer).then(a -> (ConferenceStatusResult)a.object).orNull();
                if (null != object) {
                    for (ConferenceUser conferenceUser : (List)Opt.of((Object)object).then(ConferenceStatusResult::getConferenceUsers).or(new ArrayList())) {
                        this.log(conferenceUser.getUserId() + " / " + conferenceUser.getStatus());
                    }
                }
                this.getEventBus().post((Object)object);
                solver.resolve((Object)object);
            }).error(error -> {
                try {
                    GetConferenceStatusErrorEvent event = new GetConferenceStatusErrorEvent(this.getParent().handleError(error));
                    this.getEventBus().post((Object)event);
                    throw new PromiseGetConferenceStatusErrorEventException(event, error);
                }
                catch (PromiseGetConferenceStatusErrorEventException exception) {
                    solver.reject((Throwable)exception);
                    return;
                }
            });
        });
    }
}

