/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services.conference.information;

import android.support.annotation.NonNull;
import android.util.Log;
import com.voxeet.sdk.VoxeetSdk;
import com.voxeet.sdk.json.ParticipantInfo;
import com.voxeet.sdk.models.Participant;
import com.voxeet.sdk.services.SessionService;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.services.media.VideoState;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ConferenceInformationHolder {
    private final ConcurrentHashMap<String, ConferenceInformation> mConferenceInformations = new ConcurrentHashMap();

    @NonNull
    public ConferenceInformation getInformation(@NonNull String conferenceId) {
        SessionService sessionService = VoxeetSdk.session();
        ConferenceInformation information = null;
        Participant participant = null;
        if (this.mConferenceInformations.containsKey(conferenceId)) {
            information = this.mConferenceInformations.get(conferenceId);
        }
        if (null == information) {
            participant = sessionService.getParticipant();
            if (null == participant) {
                participant = new Participant(new ParticipantInfo());
            }
            information = new ConferenceInformation(participant, conferenceId);
            this.mConferenceInformations.put(conferenceId, information);
        }
        return information;
    }

    public void setVideoState(@NonNull ConferenceInformation conferenceInformation, @NonNull VideoState videoState) {
        conferenceInformation.setVideoState(videoState);
    }

    public void moveConference(@NonNull String conferenceId, @NonNull ConferenceInformation conferenceInformation) {
        String previousId = conferenceInformation.getConference().getId();
        conferenceInformation.getConference().setConferenceId(conferenceId);
        this.mConferenceInformations.remove(previousId);
        this.mConferenceInformations.put(conferenceId, conferenceInformation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearConferencesInformation() {
        Log.d((String)"ConferenceService", (String)"clearConferencesInformation: need consensus to what must be done when logging out...");
        ConcurrentHashMap<String, ConferenceInformation> concurrentHashMap = this.mConferenceInformations;
        synchronized (concurrentHashMap) {
            Set<Map.Entry<String, ConferenceInformation>> entries = this.mConferenceInformations.entrySet();
            for (Map.Entry<String, ConferenceInformation> entry : entries) {
                entry.getValue().clean();
            }
            this.mConferenceInformations.clear();
        }
    }
}

