/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.network.websocket;

import android.support.annotation.NonNull;
import android.util.Log;
import com.voxeet.sdk.VoxeetSdk;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.network.websocket.SocketListener;
import com.voxeet.sdk.network.websocket.WebSocketProxy;
import com.voxeet.sdk.services.VoxeetDispatcher;
import com.voxeet.sdk.services.VoxeetHttp;
import com.voxeet.sdk.services.authenticate.WebSocketState;
import com.voxeet.sdk.utils.AbstractVoxeetEnvironmentHolder;
import okhttp3.WebSocket;

public class VoxeetWebSocket {
    private static final String TAG = VoxeetWebSocket.class.getSimpleName();
    private AbstractVoxeetEnvironmentHolder environment_holder;
    public static final String SOCKET_ERROR = "SOCKET_ERROR";
    public static final String SOCKET_MESSAGE = "SOCKET_TEXT";
    private String socketUrl;
    private WebSocketProxy mWebSocketProxy;
    private SocketListener listener = new SocketListener(){

        @Override
        public void onConnect(WebSocket webSocket) {
            VoxeetDispatcher.dispatch(WebSocketState.CONNECTED);
        }

        @Override
        public void onTextMessage(String message) {
            VoxeetDispatcher.dispatch(VoxeetWebSocket.SOCKET_MESSAGE, message);
        }

        @Override
        public void onError(HttpException exception) {
            exception.printStackTrace();
            if (null != exception.getResponse()) {
                try {
                    Log.d((String)TAG, (String)("onError: http exception for socket (message) " + exception.getResponse().message()));
                    Log.d((String)TAG, (String)("onError: http exception for socket (body) " + exception.getResponse().body().toString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            VoxeetDispatcher.dispatch(VoxeetWebSocket.SOCKET_ERROR, "Error " + exception.getMessage());
        }

        @Override
        public void onClose() {
        }

        @Override
        public void onStateChanged(WebSocketState newState) {
            Log.d((String)TAG, (String)("onStateChanged: newState:=" + (Object)((Object)newState)));
            VoxeetDispatcher.dispatch(newState);
        }

        @Override
        public void onDisconnected() {
            Log.d((String)TAG, (String)"Websocket disconnect by server");
            VoxeetDispatcher.dispatch(WebSocketState.CLOSED);
        }
    };

    public VoxeetWebSocket(VoxeetSdk sdk, @NonNull String socketUrl) {
        this.environment_holder = sdk.getVoxeetEnvironmentHolder();
        this.socketUrl = socketUrl;
    }

    public void connect(@NonNull VoxeetHttp provider) {
        if (null != this.mWebSocketProxy) {
            this.mWebSocketProxy.removeListeners();
            this.mWebSocketProxy.cancel();
            this.mWebSocketProxy.disconnect();
        }
        this.createProxy();
        this.mWebSocketProxy.connect(provider, null);
    }

    private void clear() {
        VoxeetDispatcher.dispatch(WebSocketState.CLOSED);
        if (null != this.mWebSocketProxy) {
            this.mWebSocketProxy.cancel();
            this.mWebSocketProxy.disconnect();
            this.mWebSocketProxy.removeListener(this.listener);
            this.mWebSocketProxy.removeListeners();
        }
        this.mWebSocketProxy = null;
    }

    private void createProxy() {
        this.mWebSocketProxy = new WebSocketProxy(this.socketUrl, this.environment_holder.getVersionName());
        this.mWebSocketProxy.addListener(this.listener);
    }

    public void close(boolean set_disconnect) {
        this.clear();
    }

    public boolean isOpen() {
        return this.mWebSocketProxy != null && this.mWebSocketProxy.isOpen();
    }

    public boolean isInit() {
        return this.mWebSocketProxy != null && this.mWebSocketProxy.isOpen();
    }
}

