/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.models.v1;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.voxeet.sdk.json.ParticipantInfo;
import com.voxeet.sdk.models.v1.ConferenceInfos;
import com.voxeet.sdk.models.v1.ConferenceParticipantStatus;
import com.voxeet.sdk.models.v1.ConferenceUser;
import com.voxeet.sdk.models.v1.PSTNItem;
import com.voxeet.sdk.models.v1.RecordingStatus;
import com.voxeet.sdk.models.v1.RestParticipant;
import com.voxeet.sdk.models.v1.UserProfile;
import com.voxeet.sdk.utils.ConferenceUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Conference {
    @JsonIgnore
    private String TAG = Conference.class.getSimpleName();
    @JsonIgnore
    private boolean isOffline;
    @JsonIgnore
    private boolean isDemo = false;
    @JsonIgnore
    private boolean hasBeenCreated = false;
    @JsonIgnore
    private boolean isGuestAccess;
    @JsonIgnore
    private boolean isRecorded = false;
    @JsonIgnore
    private Date startRecordTimestamp;
    @JsonIgnore
    private String recordingUser;
    @JsonIgnore
    private RecordingStatus recordingStatus = RecordingStatus.NOT_RECORDING;
    @JsonProperty(value="conference")
    private ConferenceInfos conferenceInfos;
    private String conferenceId;
    private String conferenceAlias;
    private String conferenceType;
    private String securityToken;
    private String meetingId;
    private String location;
    private String title;
    private String description;
    private UserProfile ownerProfile;
    private String pstnPinCode;
    private List<ConferenceUser> conferenceUsers = new ArrayList<ConferenceUser>();
    @JsonProperty(value="nodes")
    private List<PSTNItem> pstnItems;
    @JsonProperty(value="e164FallbackPhoneNumber")
    private String fallBackNumber;

    public String getFallBackNumber() {
        return this.fallBackNumber;
    }

    public void setFallBackNumber(String fallBackNumber) {
        this.fallBackNumber = fallBackNumber;
    }

    public ConferenceInfos getConferenceInfos() {
        return this.conferenceInfos;
    }

    public void setConferenceInfos(ConferenceInfos conferenceInfos) {
        this.conferenceInfos = conferenceInfos;
    }

    public List<PSTNItem> getPstnItems() {
        return this.pstnItems;
    }

    public void setPstnItems(List<PSTNItem> pstnItems) {
        this.pstnItems = pstnItems;
    }

    public boolean hasBeenCreated() {
        return this.hasBeenCreated;
    }

    public void setHasBeenCreated(boolean hasBeenCreated) {
        this.hasBeenCreated = hasBeenCreated;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getMeetingId() {
        return this.meetingId;
    }

    public void setMeetingId(String meetingId) {
        this.meetingId = meetingId;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public UserProfile getOwnerProfile() {
        return this.ownerProfile;
    }

    public void setOwnerProfile(UserProfile ownerProfile) {
        this.ownerProfile = ownerProfile;
    }

    public String getPstnPinCode() {
        return this.pstnPinCode;
    }

    public void setPstnPinCode(String pstnPinCode) {
        this.pstnPinCode = pstnPinCode;
    }

    public String getConferenceId() {
        return this.conferenceId;
    }

    public void setConferenceId(String conferenceId) {
        this.conferenceId = conferenceId;
    }

    @Nullable
    public String getConferenceType() {
        return this.conferenceType;
    }

    public void setConferenceType(String conferenceType) {
        this.conferenceType = conferenceType;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    @NonNull
    public List<ConferenceUser> getConferenceUsers() {
        if (null != this.conferenceUsers) {
            return this.conferenceUsers;
        }
        return new ArrayList<ConferenceUser>();
    }

    public int getConferenceRoomSize() {
        if (this.conferenceUsers != null) {
            return this.conferenceUsers.size();
        }
        return 0;
    }

    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    public void setConferenceUsers(List<ConferenceUser> conferenceUsers) {
        this.conferenceUsers = conferenceUsers;
    }

    public boolean isOffline() {
        return this.isOffline;
    }

    public void setOffline(boolean offline) {
        this.isOffline = offline;
    }

    public boolean isDemo() {
        return this.isDemo;
    }

    public void setDemo(boolean demo) {
        this.isDemo = demo;
    }

    public boolean isGuestAccess() {
        return this.isGuestAccess;
    }

    public void setGuestAccess(boolean guestAccess) {
        this.isGuestAccess = guestAccess;
    }

    public boolean isRecorded() {
        return this.isRecorded;
    }

    public void setRecorded(boolean recorded) {
        this.isRecorded = recorded;
    }

    public Date getStartRecordTimestamp() {
        return this.startRecordTimestamp;
    }

    public void setStartRecordTimestamp(Date startRecordTimestamp) {
        this.startRecordTimestamp = startRecordTimestamp;
    }

    public String getRecordingUser() {
        return this.recordingUser;
    }

    public ConferenceUser getUserById(String userId) {
        if (this.conferenceUsers != null) {
            return ConferenceUtils.findConferenceUserById(userId, this.conferenceUsers);
        }
        return null;
    }

    public void setRecordingUser(String recordingUser) {
        this.recordingUser = recordingUser;
    }

    public boolean isConferenceEmpty() {
        if (this.conferenceUsers == null) {
            return true;
        }
        for (ConferenceUser user : this.conferenceUsers) {
            if (user.getConferenceStatus() != ConferenceParticipantStatus.ON_AIR) continue;
            return false;
        }
        return true;
    }

    public RecordingStatus getRecordingStatus() {
        return this.recordingStatus;
    }

    public boolean isUsersOnAir() {
        if (this.conferenceUsers == null) {
            return true;
        }
        for (ConferenceUser user : this.conferenceUsers) {
            if (user.getConferenceStatus() != ConferenceParticipantStatus.ON_AIR) continue;
            return true;
        }
        return false;
    }

    public void setRecordingStatus(RecordingStatus recordingStatus) {
        this.recordingStatus = recordingStatus;
    }

    public void setConferenceAlias(String conferenceAlias) {
        this.conferenceAlias = conferenceAlias;
    }

    public String getConferenceAlias() {
        return this.conferenceAlias;
    }

    public boolean updateParticipantToConferenceUsers(@NonNull RestParticipant participant) {
        boolean found;
        ConferenceUser user = this.findUserById(participant.getParticipantId());
        boolean bl = found = null != user;
        if (null == user) {
            user = new ConferenceUser(participant.getParticipantId(), participant.getDeviceType(), new ParticipantInfo(participant.getName(), participant.getExternalId(), participant.getAvatarUrl()));
            this.getConferenceUsers().add(user);
            found = false;
        } else {
            user.updateIfNeeded(participant.getName(), participant.getAvatarUrl());
        }
        ConferenceParticipantStatus status = ConferenceParticipantStatus.fromString(participant.getStatus());
        user.setConferenceStatus(status);
        return !found;
    }

    @Nullable
    public ConferenceUser findUserById(@NonNull String userId) {
        return ConferenceUtils.findConferenceUserById(userId, this.getConferenceUsers());
    }
}

