/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.json;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.json.Event;
import com.voxeet.sdk.json.ParticipantInfo;
import com.voxeet.sdk.models.v1.Conference;
import com.voxeet.sdk.models.v1.ConferenceType;
import com.voxeet.sdk.utils.FromWebsocket;
import com.voxeet.sdk.utils.InternalEvent;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeName(value="InvitationReceivedEvent")
@InternalEvent
@FromWebsocket
public class InvitationReceivedEvent
extends Event {
    public String conferenceId;
    @JsonProperty(value="confAlias")
    @Nullable
    public String conferenceAlias;
    @JsonProperty(value="userId")
    @NonNull
    public String participantId;
    @JsonProperty(value="externalId")
    @Nullable
    public String externalId;
    @JsonProperty(value="externalName")
    @Nullable
    public String externalName;
    @JsonProperty(value="externalAvatarUrl")
    public String externalAvatarUrl;
    @Nullable
    public ParticipantInviter inviter;
    @JsonProperty(value="conferenceInfo")
    @Nullable
    public Conference conference;

    @Override
    public String getType() {
        return "InvitationReceivedEvent";
    }

    @NonNull
    public ParticipantInviter getInviter() {
        if (null == this.inviter) {
            return new ParticipantInviter(this.participantId, this.externalId, this.externalAvatarUrl, this.externalName);
        }
        return this.inviter;
    }

    @NonNull
    public ParticipantInfo infos() {
        ParticipantInviter inviter = this.getInviter();
        return new ParticipantInfo(inviter.externalName, inviter.externalId, inviter.externalAvatarUrl);
    }

    @NonNull
    public String id() {
        String conferenceId;
        if (!TextUtils.isEmpty((CharSequence)this.conferenceId)) {
            return this.conferenceId;
        }
        if (null != this.conference && null != (conferenceId = this.conference.getConferenceId())) {
            return conferenceId;
        }
        return "";
    }

    @NonNull
    public ConferenceType type() {
        if (null != this.conference && null != this.conference.getConferenceType()) {
            return ConferenceType.fromId(this.conference.getConferenceType());
        }
        return ConferenceType.SDK_CONF;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public class ParticipantInviter {
        @JsonProperty(value="userId")
        public String participantId;
        public String externalId;
        public String externalAvatarUrl;
        public String externalName;

        public ParticipantInviter() {
        }

        public ParticipantInviter(String participantId, String externalId, String externalAvatarUrl, String externalName) {
            this();
            this.participantId = participantId;
            this.externalId = externalId;
            this.externalAvatarUrl = externalAvatarUrl;
            this.externalName = externalName;
        }
    }
}

