package com.voxeet.sdk.services.presentation;

import com.voxeet.sdk.utils.Annotate;

/**
 * The PresentationState model represents all possible presentation states and their lifecycles.
 * <p>
 * The default behaviour is started. And then, the following diagram :
 * <p>
 * - started (play as well)
 * - started -> play
 * - started -> pause
 * - started -> seek
 * - started -> stop
 * <p>
 * - play -> pause
 * - play -> seek
 * - play -> stop
 * <p>
 * - pause -> play
 * - pause -> seek
 * - pause -> stop
 * <p>
 * - seek -> pause
 * - seek -> play
 * - seek -> seek
 * - seek -> stop
 * <p>
 * - stop -> terminal
 */
@Annotate
public enum PresentationState {
    STARTED,
    PLAY,
    PAUSED,
    SEEK,
    STOP,
    CONVERTED;
}
