package com.voxeet.sdk.services.localstats.events;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.sdk.services.localstats.LocalStatsParticipantInfo;
import com.voxeet.sdk.services.localstats.LocalStatsUserTypes;

public class LocalStatsUserChangeEvent {

    @NonNull
    private String userId;

    @Nullable
    private LocalStatsParticipantInfo userInfo;

    @NonNull
    private LocalStatsUserTypes lastKnownType;

    @NonNull
    private LocalStatsUserTypes currentType;

    public LocalStatsUserChangeEvent() {
        userId = "";
        lastKnownType = LocalStatsUserTypes.DEFAULT;
        currentType = LocalStatsUserTypes.DEFAULT;

    }

    public LocalStatsUserChangeEvent(@NonNull String userId,
                                     @NonNull LocalStatsParticipantInfo userInfo,
                                     @NonNull LocalStatsUserTypes lastKnownType,
                                     @NonNull LocalStatsUserTypes currentType) {
        this();

        this.userId = userId;
        this.userInfo = userInfo;
        this.lastKnownType = lastKnownType;
        this.currentType = currentType;
    }

    @NonNull
    public String getUserId() {
        return userId;
    }

    @Nullable
    public LocalStatsParticipantInfo getUserInfo() {
        return userInfo;
    }

    @NonNull
    public LocalStatsUserTypes getLastKnownType() {
        return lastKnownType;
    }

    @NonNull
    public LocalStatsUserTypes getCurrentKnownType() {
        return currentType;
    }
}
