package com.voxeet.sdk.services.chat;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.sdk.models.Participant;
import com.voxeet.sdk.models.v2.ChatMessage;
import com.voxeet.sdk.utils.Annotate;

/**
 * Contains chat information.
 */
@Annotate
public class ChatMessageEvent {
    /**
     * The instance of the `Participant` who emitted the message.
     */
    @Nullable
    public Participant participant;

    /**
     * The instance of the message sent by the `Participant`.
     */
    @NonNull
    public ChatMessage message;

    /**
     * Creates a new message including `participant` and `message`.
     *
     * @param participant instance of the participant or null if sent by system
     * @param message message to be sent
     */
    public ChatMessageEvent(@Nullable Participant participant, @NonNull ChatMessage message) {
        this.participant = participant;
        this.message = message;
    }
}
