package com.voxeet.sdk.services.builders;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.sdk.json.internal.MetadataHolder;
import com.voxeet.sdk.json.internal.ParamsHolder;
import com.voxeet.sdk.services.conference.information.ConferenceParticipantType;
import com.voxeet.sdk.utils.Annotate;

/**
 * The ConferenceJoinInformation.Builder model is responsible for building conferences. It creates a [new builder](/documentation/sdk/reference/android/models/conferencejoininformation.builder#builder) and the [ConferenceJoinInformation instance](/documentation/sdk/reference/android/models/conferencejoininformation.builder#build). It also sets [parameters](/documentation/sdk/reference/android/models/conferencejoininformation.builder#setparamsholder) and [types of participants](/documentation/sdk/reference/android/models/conferencejoininformation.builder#setconferenceparticipanttype).
 */
@Annotate
public class ConferenceJoinInformation {
    private String conferenceId;
    //private MetadataHolder metadataHolder;
    private ParamsHolder paramsHolder;
    private ConferenceParticipantType conferenceParticipantType;

    private ConferenceJoinInformation() {

    }


    /**
     * Gets the conference ID.
     * @return the conference ID if it is set to a valid value, a null value otherwise.
     */
    @Nullable
    public String getConferenceId() {
        return conferenceId;
    }

    /**
     * Gets parameters for the conference.
     * @return the holder instance or a null value.
     */
    @Nullable
    private /*public*/ MetadataHolder getMetadataHolder() {
        return null; //return metadataHolder;
    }

    /**
     * Gets conference parameters.
     * @return the holder instance or a null value.
     */
    @Nullable
    public ParamsHolder getParamsHolder() {
        return paramsHolder;
    }

    /**
     * Gets the specified participant type. It is used locally.
     * @return the type requested in a builder.
     */
    @NonNull
    public ConferenceParticipantType getConferenceParticipantType() {
        return conferenceParticipantType;
    }

    /**
     * The ConferenceJoinInformation.Builder model is responsible for building conferences. It creates a [new builder](/documentation/sdk/reference/android/models/conferencejoininformation.builder#builder) and the [ConferenceJoinInformation instance](/documentation/sdk/reference/android/models/conferencejoininformation.builder#build). It also sets [parameters](/documentation/sdk/reference/android/models/conferencejoininformation.builder#setparamsholder) and [types of participants](/documentation/sdk/reference/android/models/conferencejoininformation.builder#setconferenceusertype).
     */
    @Annotate
    public static class Builder {
        private ConferenceJoinInformation conferenceJoinInformation;

        private Builder() {
            conferenceJoinInformation = new ConferenceJoinInformation();
        }

        /**
         * Creates a new builder.
         * @param conferenceId The valid conference ID.
         */
        public Builder(@NonNull String conferenceId) {
            this();

            conferenceJoinInformation.conferenceId = conferenceId;
        }

        /**
         * Adds parameters into a conference.
         * @param metadataHolder the reference to the metadata
         * @return a builder instance.
         */
        private /*public*/ Builder setMetadataHolder(@Nullable MetadataHolder metadataHolder) {
            //conferenceJoinInformation.metadataHolder = metadataHolder;
            return this;
        }

        /**
         * Adds parameters into the conference.
         *
         * @param paramsHolder The reference to parameters.
         * @return the builder instance.
         */
        public Builder setParamsHolder(@Nullable ParamsHolder paramsHolder) {
            conferenceJoinInformation.paramsHolder = paramsHolder;
            return this;
        }

        /**
         * Sets the type of the joining participant, from a local point of view.
         * There are the following participant types: normal (by default), broadcaster (for streaming and broadcasting modes), or listener (only for receiving information).
         *
         * @param conferenceParticipantType The specified type of the conference participant.
         * @return the builder instance.
         */
        public Builder setConferenceParticipantType(@NonNull ConferenceParticipantType conferenceParticipantType) {
            conferenceJoinInformation.conferenceParticipantType = conferenceParticipantType;
            return this;
        }

        /**
         * Constructs the corresponding `ConferenceJoinInformation` from the data set.
         * @return a new valid instance of the conference join representation.
         */
        @NonNull
        public ConferenceJoinInformation build() {
            return conferenceJoinInformation;
        }

    }
}
