package com.voxeet.sdk.network.websocket;

import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.services.authenticate.WebSocketState;

import okhttp3.WebSocket;

/**
 * The interface Socket listener which can be used when trying to connect to the server.
 */
public interface SocketListener {
    /**
     * On connect.
     */
    void onConnect(WebSocket webSocket);

    void onTextMessage(String message);

    void onError(HttpException exception);

    void onClose();

    void onStateChanged(WebSocketState newState);

    void onDisconnected();
}
