package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;
import com.voxeet.sdk.utils.NoDocumentation;
import com.voxeet.sdk.utils.ToDelete;

@Annotate
@ToDelete
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.TYPING_DETECTION)
public class TypingDetection extends Event {

    public boolean typing;

    @NoDocumentation
    @Override
    public String getType() {
        return EventNames.TYPING_DETECTION;
    }
}
