package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.models.v1.OfferCandidate;
import com.voxeet.sdk.models.v1.OfferDescription;

import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.START_VIDEO)
public class StartVideoResponse extends Event {

    @JsonProperty("candidates")
    public List<OfferCandidate> candidates;

    @JsonProperty("description")
    public OfferDescription description;

    @JsonProperty("user_id")
    public String participantId;

    @Override
    public String getType() {
        return EventNames.START_VIDEO;
    }
}
