package com.voxeet.sdk.json;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.models.v1.Conference;
import com.voxeet.sdk.models.v1.ConferenceType;
import com.voxeet.sdk.models.v1.Invitation;
import com.voxeet.sdk.models.v1.UserProfile;
import com.voxeet.sdk.utils.FromWebsocket;
import com.voxeet.sdk.utils.InternalEvent;
import com.voxeet.sdk.utils.Opt;

import java.util.List;

@InternalEvent
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.INVITATION_RECEIVED)
public class InvitationReceivedEvent extends Event {
    public String conferenceId;

    @Nullable
    @JsonProperty("confAlias")
    public String conferenceAlias;

    @NonNull
    @JsonProperty("userId")
    public String participantId;

    @Nullable
    @JsonProperty("externalId")
    public String externalId;

    @Nullable
    @JsonProperty("externalName")
    public String externalName;

    @JsonProperty("externalAvatarUrl")
    public String externalAvatarUrl;

    @Nullable
    public ParticipantInviter inviter;

    @Nullable
    @JsonProperty("conferenceInfo")
    public Conference conference;

    @Override
    public String getType() {
        return EventNames.INVITATION_RECEIVED;
    }

    @NonNull
    public ParticipantInviter getInviter() {
        if (null == inviter) {
            return new ParticipantInviter(participantId, externalId, externalAvatarUrl, externalName);
        }
        return inviter;
    }

    @NonNull
    public ParticipantInfo infos() {
        ParticipantInviter inviter = getInviter();
        return new ParticipantInfo(inviter.externalName, inviter.externalId, inviter.externalAvatarUrl);
    }

    @NonNull
    public String id() {
        if (!TextUtils.isEmpty(conferenceId)) return conferenceId;

        if (null != conference) {
            String conferenceId = conference.getConferenceId();
            if (null != conferenceId) return conferenceId;
        }
        return "";
    }

    @NonNull
    public ConferenceType type() {
        if (null != conference && null != conference.getConferenceType()) {
            return ConferenceType.fromId(conference.getConferenceType());
        }
        return ConferenceType.SDK_CONF;
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public class ParticipantInviter {

        public ParticipantInviter() {

        }

        public ParticipantInviter(String participantId, String externalId, String externalAvatarUrl, String externalName) {
            this();
            this.participantId = participantId;
            this.externalId = externalId;
            this.externalAvatarUrl = externalAvatarUrl;
            this.externalName = externalName;
        }

        @JsonProperty("userId")
        public String participantId;

        public String externalId;

        public String externalAvatarUrl;

        public String externalName;
    }
}
