package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;
import com.voxeet.sdk.utils.InternalEvent;

@Annotate
@InternalEvent
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.FILE_PRESENTATION_UPDATED)
public class FilePresentationUpdated extends Event {

    public String conferenceId;

    public String userId;

    public String fileId;

    public int position;

    @Override
    public String getType() {
        return EventNames.FILE_PRESENTATION_UPDATED;
    }
}
